<!DOCTYPE html>

<html lang="en">
<!-- To declare your language - read more here: https://www.w3.org/International/questions/qa-html-language-declarations -->
<head>
<title>Bierstadt | Art Experts</title>
<meta name="description" content="Bierstadt art authentication, Bierstadt appraisal, Full painting authentications. Certificate of authenticity (COA). we will sell your Bierstadt.">
<meta name=”robots” content="index, follow">























<link href="../layout/styles/test-layout.css" rel="stylesheet" type="text/css" media="all">
<link rel="stylesheet" type="text/css" href="https://cdn.jsdelivr.net/npm/cookieconsent@3/build/cookieconsent.min.css" />
<!-- Global site tag (gtag.js) - Google Analytics -->
<script async src="https://www.googletagmanager.com/gtag/js?id=G-NZ7GKNVDYS"></script>
<script>
  window.dataLayer = window.dataLayer || [];
  function gtag(){dataLayer.push(arguments);}
  gtag('js', new Date());

  gtag('config', 'G-NZ7GKNVDYS');
</script>
<link rel="canonical" href="<?php echo 'https://' . $_SERVER['HTTP_HOST'] . $_SERVER['REQUEST_URI']; ?>"><meta name="viewport" content="width=device-width, initial-scale=1.0"></head>

<?php include($_SERVER['DOCUMENT_ROOT']."/includes/header2.php");  ?>
<!-- ################################################################################################ -->
<!-- ################################################################################################ -->
<!-- ################################################################################################ -->

<!-- ################################################################################################ -->
<!-- ################################################################################################ -->
<!-- ################################################################################################ -->
<div class="wrapper row3">
  <main class="hoc container clear"> 
    <!-- main body -->
    <!-- ################################################################################################ -->
    <div class="content three_quarter first" id="three_connn"> 
      <!-- ################################################################################################ -->

      
      
      <div class="wow fadeInLeft" data-wow-delay=".4s">
        <h1>Albert Bierstadt (1830-1902)</h1>
      </div>
      <p class="wow fadeInLeft" data-wow-delay=".4s">We Perform Bierstadt art authentication. <a href="https://www.artexpertswebsite.com/appraisal/painting-appraisal.php">Bierstadt appraisal</a> from . <a href="https://www.artexpertswebsite.com/authentication/certificate-of-authenticity.php">Bierstadt certificates of authenticity (COA)</a>.  Bierstadt analysis, <a href="https://www.artexpertswebsite.com/authentication/provenance-research.php">research</a>, <a href="https://www.artexpertswebsite.com/authentication/scientific-tests.php">scientific tests</a>, <a href="https://www.artexpertswebsite.com/authentication.php">full art authentications</a>. We will help you sell your Bierstadt or we will sell it for you.</p>
      <p class="wow fadeInLeft" data-wow-delay=".4s">German-born, Bierstadt moved to New Bedford, Massachusetts with his family at the age of two. He returned to Düsseldorf, Germany in 1853 and studied painting there until 1857. That year, he returned to New Bedford and organized an exhibition featuring his work as well as other artists. This was the launching point of Bierstadt’s career, a man who would become known as the foremost painter of the American west.</p>
      <p align="center" class="wow fadeInRight" data-wow-delay=".4s"><img src="uploads/artists/artists_a-k/bierstadt/Bierstadt_StormInTheRockyMountains.jpg" alt="Storm in the Rocky Mountains" width="auto"></p>
      <div class="boldcap wow fadeInRight" data-wow-delay=".4s">Storm in the Rocky Mountains</div>
      <p class="wow fadeInLeft" data-wow-delay=".4s">Almost completely a landscape painter, Bierstadt wowed the Eastern United States with his giant oil paintings of the west. He became internationally famous for his sweeping panoramas of the pristine western wilderness. His work of the west brought in extremely high prices for the day, in both public and private collections.</p>
      <p align="center" class="wow fadeInRight" data-wow-delay=".4s"><img src="uploads/artists/artists_a-k/bierstadt/Bierstadt_TheLastOfTheBuffalo.jpg" alt="The Last of the Buffalo" width="auto"></p>
      <div class="boldcap wow fadeInRight" data-wow-delay=".4s">The Last of the Buffalo</div>
      <p class="wow fadeInLeft" data-wow-delay=".4s">Bierstadt’s oil paintings would produce a beautiful golden light that no digital artist could equally recreate today. While his subjects were often breathtaking enough (Yosemite, the Pacific north, Niagara Falls and mountains) it was his style that brought the west to life. Easterners would be in awe of his work, and many would describe them as having a “religious” or “ethereal” value. The spray of a waterfall or the glow of a sunset through the mountains created a transcendental feel to those who had never seen the beauty of the west before. These are reflected in such works as “Bridal Veil Falls, Yosemite” (1871-1873).</p>
      <p align="center" class="wow fadeInRight" data-wow-delay=".4s"><img src="uploads/artists/artists_a-k/bierstadt/bierstadt_Bridal_Veil_Falls.jpg" alt="Bridal Veil Falls, Yosemite" border="0"></p>
      <div class="boldcap wow fadeInRight" data-wow-delay=".4s">Bridal Veil Falls, Yosemite</div>
      <p class="wow fadeInLeft" data-wow-delay=".4s">Aside from their beauty, Bierstadt’s paintings were also behemoth in comparison to most other canvases. In order to fully capture the panorama of wide open, pristine nature, Bierstadt would often paint on an unusually large scale. One of his most famous works “The Emerald Pool” (1870) measures in at more than 76in tall x 119in long (about 6 x 10 feet). If there is a fairly large painting of the west in your parlor, it is highly likely that it was painted by Albert Bierstadt.</p>
      <p align="center" class="wow fadeInRight" data-wow-delay=".4s"><img src="uploads/artists/artists_a-k/bierstadt/bierstadt_The_Emerald_Pool.jpg" alt="The Emerald Pool" width="auto" border="0"></p>
      <div class="boldcap wow fadeInRight" data-wow-delay=".4s">The Emerald Pool</div>
      <p class="wow fadeInLeft" data-wow-delay=".4s">Bierstadt can only be described as a realist landscape painter, and his attention to detail is remarkable. While people and animals often appear as part of his backdrop, and not as the subject, he still gave them crisp details and features. A great example is one of his early paintings done in Europe, “The Arch of Octavius” (1858). A cat scampers across the foreground of this scene, people are mingling in a marketplace, yet the arch itself is the most dominant object in the painting. He would also paint American Indians and their homes and artifacts in his paintings, but they too would serve more as a backdrop than a subject.</p>
      <p align="center" class="wow fadeInRight" data-wow-delay=".4s"><img src="uploads/artists/artists_a-k/bierstadt/bierstadtThe_Arch_of_Octavius.jpg" alt="The Arch of Octavius" width="auto" border="0"></p>
      <div class="boldcap wow fadeInRight" data-wow-delay=".4s">The Arch of Octavius</div>
      <p class="wow fadeInLeft" data-wow-delay=".4s">His brother, Edward, was a photographer, and Bierstadt worked in that medium as well, though his photography is not as well archived or housed in museums. On his trips to the west, he would take photos to help him remember what he wanted to paint when he would return to his studio in New York. Where are these photos that Bierstadt took? They would serve as great historic and artistic value as an accompaniment to the paintings that were produced from them. He was also known to make sketches during these wagon trips west of what he saw, and they would also be valuable if found and verified as Bierstadt’s.</p>
      <p align="center" class="wow fadeInRight" data-wow-delay=".4s"><img src="uploads/artists/artists_a-k/bierstadt/Bierstadt_TheOregonTrail.jpg" alt="The Oregon Trail" width="auto"></p>
      <div class="boldcap wow fadeInRight" data-wow-delay=".4s">The Oregon Trail</div>
      <p class="wow fadeInLeft" data-wow-delay=".4s">Bierstadt was very ambitious, and a relentless marketer of his own work, acquirer of awards, collector of commissions and seeker of endorsements. He did this on both sides of the Atlantic. When his popularity waned in America, he went to Europe and opened studios, etc. He wrote to everyone imaginable trying to get his name in every conceivable published, well-distributed directory of artists. Also he got himself appointed the head of various official sounding “departments” at fairs around the country. I’ve never seen such blatant careerism in a nineteenth century artist. He was extremely good at getting newspaper coverage every time he sneezed and made a then-record sale of “The Rocky Mountains, Lander’s Peak,” for $25,000 in winter 1865.</p>
      <p align="center" class="wow fadeInRight" data-wow-delay=".4s"><img src="uploads/artists/artists_a-k/bierstadt/Bierstadt_TheRockyMountainsLandersPeak.jpg" alt="The Rocky Mountains Lander's Peak"></p>
      <div class="boldcap wow fadeInRight" data-wow-delay=".4s">The Rocky Mountains Lander’s Peak</div>
      <p class="wow fadeInLeft" data-wow-delay=".4s">In 1882, his studio in Irvington, New York was destroyed in a fire and many of valuable paintings were lost. This too leaves a wide-open possibility of some of his work surviving the fire (possibly from looters) or that some were saved in fragments. In 1893 he wrote to President Cleveland: [this without corrections of misspellings] “Give us free Art, good pictures we are not afraid of, it is the imitations, counterfits that injure not only the Artist but the buyer.”</p>
      <p align="center" class="wow fadeInRight" data-wow-delay=".4s"><img src="uploads/artists/artists_a-k/bierstadt/Bierstadt_Niagara.jpg" alt="Niagara"></p>
      <div class="boldcap wow fadeInRight" data-wow-delay=".4s">Niagara</div>
      <p class="wow fadeInLeft" data-wow-delay=".4s">Bierstadt and his second wife made a trip to the European Alps in summer 1895, also in 1896 they went to Lucerne and Budapest. In 1896 he wrote to his family that he might move back to Europe permanently. In 1897 he and his wife returned to Geneva and other parts of Switzerland. Bierstadt got a patent in 1895 on a “railway car” that could also be converted into a church or a fort. Sadly, his invention was never manufactured or marketed. In 1899, Bierstadt tried to convince President McKinley that the U.S. government should buy a castle on Corfu–Achillon, that belonged to the Empress of Austria. Bierstadt thought we should give it to Queen Victoria to prevent her from taking her holidays in France.</p>
      <p align="center" class="wow fadeInRight" data-wow-delay=".4s"><img src="uploads/artists/artists_a-k/bierstadt/Bierstadt_AlongTheHudson.jpg" alt="Along the Hudson" width="auto"></p>
      <div class="boldcap wow fadeInRight" data-wow-delay=".4s">Along the Hudson</div>
      <p class="wow fadeInLeft" data-wow-delay=".4s">While Bierstadt’s catalog generally consists of landscapes of the west (more than 400 on record), he must have done many other lesser-known paintings before them while studying in Europe. Where are they, and what could they contain? His “Arch of Octavius” has been put under scrutiny for bearing anti-Catholic symbolism as well as symbolism about emigrants. Could Bierstadt have made other such symbolic paintings while in his youth in Europe?</p>
      <p align="center" class="wow fadeInRight" data-wow-delay=".4s"><img src="uploads/artists/artists_a-k/bierstadt/Bierstadt_TheMountainsBrook.jpg" alt="The Mountain's Brook" width="auto"></p>
      <div class="boldcap wow fadeInRight" data-wow-delay=".4s">The Mountain’s Brook</div>
      <p class="wow fadeInLeft" data-wow-delay=".4s">Similarly, the painting “Mount Shasta” by fellow artist Ferdinand Schafer has caused speculation in the art world because it bears such a resemblance to other paintings of Mount Shasta by Albert Bierstadt. So close, in fact, that one of Schafer’s paintings was initially attributed to Bierstadt in 1964 after being acquired by the Oakland Museum. The two artists even signed their work similarly.</p>
      <p align="center" class="wow fadeInRight" data-wow-delay=".4s"><img src="uploads/artists/artists_a-k/bierstadt/Bierstadt_MountShastaAndCastleLake.jpg" alt="Mount Shasta and Castle Lake" width="auto"></p>
      <div class="boldcap wow fadeInRight" data-wow-delay=".4s">Mount Shasta and Castle Lake</div>
      <p class="wow fadeInLeft" data-wow-delay=".4s">Toward the end of his career, French Impressionism started to become popular, and the demand for his work declined. Despite the staggering amount of money his paintings brought in, he declared bankruptcy in 1895. Today, his work is housed all over the United States, including the Metropolitan Museum, as well as the Capitol building in Washington D.C.</p>
     
      <!-- ################################################################################################ -->
    </div>


  </main>
</div>
<!-- ################################################################################################ -->
<!-- ################################################################################################ -->
<!-- ################################################################################################ -->
<?php include($_SERVER['DOCUMENT_ROOT']."/includes/footer.php");  ?>
<!-- ################################################################################################ -->
<!-- ################################################################################################ -->
<!-- ################################################################################################ -->
<?php include($_SERVER['DOCUMENT_ROOT']."/includes/copyright.php");  ?><!-- ################################################################################################ -->
<!-- ################################################################################################ -->
<!-- ################################################################################################ -->
<a id="backtotop" href="#top"><i class="fa fa-chevron-up"></i></a>
<!-- JAVASCRIPTS -->
<script src="../layout/scripts/jquery.min.js"></script>
<script src="../layout/scripts/jquery.backtotop.js"></script>
<script src="../layout/scripts/jquery.mobilemenu.js"></script>
<script src="https://cdn.jsdelivr.net/npm/cookieconsent@3/build/cookieconsent.min.js" data-cfasync="false"></script>
<script>
window.cookieconsent.initialise({
  "palette": {
    "popup": {
      "background": "#474747"
    },
    "button": {
      "background": "#9d0552"
    }
  },
  "content": {
    "message": "This website uses cookies to improve your experience. We'll assume you're ok with this, but you can opt-out if you wish.",
    "dismiss": "Accept Cookies"
  }
});
</script>

</body>
</html>