<!DOCTYPE html>

<html lang="en">
<!-- To declare your language - read more here: https://www.w3.org/International/questions/qa-html-language-declarations -->
<head>
<title>Eugène Boudin | Art Experts</title>
<meta name="description" content="Eugène Boudin art authentication, Eugène Boudin appraisal, Full painting authentications. Certificate of authenticity (COA). we will sell your Eugène Boudin.">
<meta name=”robots” content="index, follow">

























<link href="../layout/styles/test-layout.css" rel="stylesheet" type="text/css" media="all">
<link rel="stylesheet" type="text/css" href="https://cdn.jsdelivr.net/npm/cookieconsent@3/build/cookieconsent.min.css" />
<!-- Global site tag (gtag.js) - Google Analytics -->
<script async src="https://www.googletagmanager.com/gtag/js?id=G-NZ7GKNVDYS"></script>
<script>
  window.dataLayer = window.dataLayer || [];
  function gtag(){dataLayer.push(arguments);}
  gtag('js', new Date());

  gtag('config', 'G-NZ7GKNVDYS');
</script>
<link rel="canonical" href="<?php echo 'https://' . $_SERVER['HTTP_HOST'] . $_SERVER['REQUEST_URI']; ?>"><meta name="viewport" content="width=device-width, initial-scale=1.0"></head>

<?php include($_SERVER['DOCUMENT_ROOT']."/includes/header2.php");  ?>
<!-- ################################################################################################ -->
<!-- ################################################################################################ -->
<!-- ################################################################################################ -->

<!-- ################################################################################################ -->
<!-- ################################################################################################ -->
<!-- ################################################################################################ -->
<div class="wrapper row3">
  <main class="hoc container clear"> 
    <!-- main body -->
    <!-- ################################################################################################ -->
    <div class="content three_quarter first" id="three_connn"> 
      <!-- ################################################################################################ -->

      
      
      <div class="wow fadeInLeft" data-wow-delay=".4s">
        <h1>Eugène Boudin (1824-1898)</h1>
      </div>
      <p class="wow fadeInLeft" data-wow-delay=".4s">We Perform Eugène Boudin art authentication. <a href="https://www.artexpertswebsite.com/appraisal/painting-appraisal.php">Eugène Boudin appraisal</a>. <a href="https://www.artexpertswebsite.com/authentication/certificate-of-authenticity.php">Eugène Boudin certificates of authenticity (COA)</a>.  Eugène Boudin analysis, <a href="https://www.artexpertswebsite.com/authentication/provenance-research.php">research</a>, <a href="https://www.artexpertswebsite.com/authentication/scientific-tests.php">scientific tests</a>, <a href="https://www.artexpertswebsite.com/authentication.php">full art authentications</a>. We will help you sell your Eugène Boudin or we will sell it for you.</p>
      <p class="wow fadeInLeft" data-wow-delay=".4s">The son of a marine pilot, and a young sailor himself, Eugène Boudin was always drawn to the sea. At 22, Boudin abandoned sailing and began to work in an art store as a framing apprentice. In his spare time, he would sketch and draw, which helped to initiate his love of art. From then on, Boudin began his journey to become France’s best-loved marine painter.</p>
      <p class="wow fadeInLeft" data-wow-delay=".4s">Boudin received a three year scholarship from the town he lived in, Le Havre, to study art in Paris. Strangely, none of his work in this three year period is known to exist today. It is said that much of Boudin’s early work was lost. However, records suggest that he may have painted still life’s of game and wildlife in the 17th century Dutch and Flemish style. Since it is not recorded why or how these pieces were lost, it is most likely that some of his earliest work may be in existence today. This would include his sketching done at the art store, as well as non-marine scenes, possibly unsigned or signed with his trademark “E. Boudin.”</p>
      <p class="wow fadeInLeft" data-wow-delay=".4s">After his return from Paris, Boudin began to work with other painters of the time like Jongkind, Bazille and Monet. Together, they formed an unofficial School of St. Simeon in the Barbizon style. Boudin became a mentor to Monet, and introduced him to his style of “plein-air” painting. Essentially, Boudin taught them the importance of painting outdoors. The majority of Boudin’s work was painted on location, and to him, it was far better than painting in a studio. In fact, Boudin was one of the first French painters to actually paint in the open air, and not from memory or a studio. Boudin became a life-long mentor to Monet, who was known to credit his master often for his career in art.</p>
      <p class="wow fadeInLeft" data-wow-delay=".4s">Their work signaled the beginning of the Impressionistic style. While Boudin is more of a pre-Impressionist/Naturalist, he became affiliated with the Impressionists when he exhibited at their first salon in 1874. From the 1870’s on, Boudin’s work has the touch of an Impressionists hand, with a brighter color palette and blurred brush strokes. Boudin was known to paint on both oil and wood, and also in watercolor on a very small scale.</p>
      <p class="wow fadeInLeft" data-wow-delay=".4s">By this time in the late 1870’s, Boudin was renowned, and was wealthy enough to travel to Holland, Venice and Belgium. No matter where he went, Boudin found himself painting the sea. At home, in France, a majority of his paintings were of the beach in Trouville.</p>
      <p class="wow fadeInLeft" data-wow-delay=".4s">Though people, as subjects in his oil paintings, often played second fiddle to deteriorating sailboats or the foamy surf, they were still given a great deal of character and detail. Parasols, bustles, hats, games and leisure activities of the day were all documented in his work. His painting “Bathers on the Beach at Trouville” (1869) is a great example of the way that Boudin would capture the livelihood of French beach-goers. Though their expressions are often barely visible in his work, his people seem alive and always caught in a candid moment. For this reason, as well as his plein-air technique, Boudin has been called the most original French marine painter of the 19th century.</p>
      <p align="center" class="wow fadeInRight" data-wow-delay=".4s"><img src="uploads/artists/artists_a-k/boudin/boudin_bathersonthebeachoftrouville.jpg" alt="art"></p>
      <div class="boldcap wow fadeInRight" data-wow-delay=".4s">Bathers on the Beach at Trouville</div>
      <p>Most notable was the way that Boudin painted the sky in his work. “The Coast of Portrieux, Cotes-du-Nord” (1874) is a fine example of the way that Boudin was able to make his canvas illuminate. In this oil-painting, fluffy white clouds float over a coastline in a real, yet dream-like, way that only an Impressionist could produce. Corot, one of his contemporaries, called him the master of the sky.</p>
      <p align="center" class="wow fadeInRight" data-wow-delay=".4s"><img src="uploads/artists/artists_a-k/boudin/boudin_the_coast_of_portrieux.jpg" alt="art"></p>
      <div class="boldcap wow fadeInRight" data-wow-delay=".4s">The Coast of Portrieux, Cotes-du-Nord</div>
      <p>Toward the end of his life, Boudin received a gold medal from the salon at the Exposition Universelle in 1889. Recently his oil painting “Berck, la Plage a Maree Basse” was set at $40,000-$50,000 at South Bay Auctions.</p>
      <p align="center" class="wow fadeInRight" data-wow-delay=".4s"><img src="uploads/artists/artists_a-k/boudin/Boudin_LeHavreBassindeLEure.jpg" alt="art"></p>
      <div class="boldcap wow fadeInRight" data-wow-delay=".4s">Le Havre, Bassin de L’Eure</div>
      <p>If you believe you own a work of art by Eugène Boudin, <a href="https://www.artexpertswebsite.com/contact/contact1.php">contact</a> Art Experts. We authenticate, appraise, research and provide Certificates of Authenticity (COA's) for works by Eugène Boudin.</p>
      <!-- ################################################################################################ -->
    </div>
    <!-- ################################################################################################ -->
    <!-- ################################################################################################ -->
    
    <!-- ################################################################################################ -->
    <!-- / main body -->

  </main>
</div>
<!-- ################################################################################################ -->
<!-- ################################################################################################ -->
<!-- ################################################################################################ -->
<?php include($_SERVER['DOCUMENT_ROOT']."/includes/footer.php");  ?>
<!-- ################################################################################################ -->
<!-- ################################################################################################ -->
<!-- ################################################################################################ -->
<?php include($_SERVER['DOCUMENT_ROOT']."/includes/copyright.php");  ?><!-- ################################################################################################ -->
<!-- ################################################################################################ -->
<!-- ################################################################################################ -->
<a id="backtotop" href="#top"><i class="fa fa-chevron-up"></i></a>
<!-- JAVASCRIPTS -->
<script src="../layout/scripts/jquery.min.js"></script>
<script src="../layout/scripts/jquery.backtotop.js"></script>
<script src="../layout/scripts/jquery.mobilemenu.js"></script>
<script src="https://cdn.jsdelivr.net/npm/cookieconsent@3/build/cookieconsent.min.js" data-cfasync="false"></script>
<script>
window.cookieconsent.initialise({
  "palette": {
    "popup": {
      "background": "#474747"
    },
    "button": {
      "background": "#9d0552"
    }
  },
  "content": {
    "message": "This website uses cookies to improve your experience. We'll assume you're ok with this, but you can opt-out if you wish.",
    "dismiss": "Accept Cookies"
  }
});
</script>

</body>
</html>