<!DOCTYPE html>

<html lang="en">
<!-- To declare your language - read more here: https://www.w3.org/International/questions/qa-html-language-declarations -->
<head>
<title>Maximilien Luce | Art Experts</title>
<meta name="description" content="Maximilien Luce art authentication, Maximilien Luce appraisal, Full painting authentications. Certificate of authenticity (COA). we will sell your Maximilien Luce.">
<meta name=”robots” content="index, follow">























<link href="../layout/styles/test-layout.css" rel="stylesheet" type="text/css" media="all">
<link rel="stylesheet" type="text/css" href="https://cdn.jsdelivr.net/npm/cookieconsent@3/build/cookieconsent.min.css" />
<!-- Global site tag (gtag.js) - Google Analytics -->
<script async src="https://www.googletagmanager.com/gtag/js?id=G-NZ7GKNVDYS"></script>
<script>
  window.dataLayer = window.dataLayer || [];
  function gtag(){dataLayer.push(arguments);}
  gtag('js', new Date());

  gtag('config', 'G-NZ7GKNVDYS');
</script>
<link rel="canonical" href="<?php echo 'https://' . $_SERVER['HTTP_HOST'] . $_SERVER['REQUEST_URI']; ?>"><meta name="viewport" content="width=device-width, initial-scale=1.0"></head>

<?php include($_SERVER['DOCUMENT_ROOT']."/includes/header2.php");  ?>



<div class="wrapper bgded overlay" style="display:none;background-image:url(../images/demo/backgrounds/09.png);">
  <div id="breadcrumb" class="hoc clear"> 
    
    
  </div>
</div>



<div class="wrapper row3">
  <main class="hoc container clear"> 
    <!-- main body -->
    
    <div class="content three_quarter first" id="three_connn"> 
      

      
      
      <div>
        <h1 class="wow fadeInLeft" data-wow-delay=".4s">Maximilien Luce (1858-1941)</h1>
      </div>
      <p class="wow fadeInLeft" data-wow-delay=".4s">We Perform Maximilien Luce lived in Paris most of his life, and was born and died there. Schooled in the Ecole des Arts Decoratifs, he served a term in the military and afterwards started his career as a newspaper engraver. During his time in the service, he met with many other influential artists, such as Camille Pissaro and Charles Emile Carolus-Duran who introduced him to their world of art.</p>
      <p class="wow fadeInLeft" data-wow-delay=".4s">Through his friendship with Pissaro, Luce adopted the ideas of the Divisionists and painted mostly in Pointillism in the beginning. He adhered to the style of Pointillism for quite some time, composing strictly in this manner.</p>
      <p class="wow fadeInLeft" data-wow-delay=".4s">Living in Paris and Montmartre all of his life, naturally Luce’s work took on themes of Parisian life. He mostly painted social scenes, landscapes and portraits, as well as monuments and landmarks such as “Notre-Dame” (1901).</p>
      <p  class="wow fadeInRight" data-wow-delay=".4s"><img border="0" src="uploads/artists/artists_l-z/luce/Luce_NotreDame.jpg" alt="art" width="auto" height="auto"></p>
      <div class="boldcap wow fadeInRight" data-wow-delay=".4s">Notre Dame</div>
      <p class="wow fadeInLeft" data-wow-delay=".4s">Though he painted portraits typical to the Pointillist/Impressionist period—shorelines, still life, flowers in vases, the French countryside—Luce also incorporated a social message into some of his work. He was involved with Anarchists and supported some of their ideas, and even became briefly imprisoned at one time.</p>
      <p class="wow fadeInLeft" data-wow-delay=".4s">One such social message can be seen in “Etude d’Homme, Pêcheur” which depicts the backside of a fisherman at work. This scene glorifies the working class and was perhaps Luce’s way of drawing attention to that aspect of society.</p>
      <p  class="wow fadeInRight" data-wow-delay=".4s"><img border="0" src="uploads/artists/artists_l-z/luce/Luce_EtudeDHomme.jpg" alt="art" width="auto" height="auto"></p>
      <div class="boldcap wow fadeInRight" data-wow-delay=".4s">Etude d’Homme, Pêcheur</div>
      <p class="wow fadeInLeft" data-wow-delay=".4s">Luce was an avid painter of the working class, and often depicted factories, city scenes and construction zones as well as scenes of war and wounded soldiers. Luce was unique in his paintings of factories with smoke billowing into the sky. They were far different from the idealistic paintings of other Impressionists of the day, and create an ominous feeling.</p>
      <p class="wow fadeInLeft" data-wow-delay=".4s">Darker still is his painting “La Commune” (1903-1905) which depicts bodies lying next to rubble in the street.</p>
      <p  class="wow fadeInRight" data-wow-delay=".4s"><img border="0" src="uploads/artists/artists_l-z/luce/Luce_LaCommune.jpg" alt="art" width="auto" height="auto"></p>
      <div class="boldcap wow fadeInRight" data-wow-delay=".4s">La Commune</div>
      <p class="wow fadeInLeft" data-wow-delay=".4s">Luce traveled selectively in his artistic endeavors. London, Brittany and Normandy were some of the few places he ventured to outside of Paris, and during his travels he continued to paint scenes of Social Realism. He served in the army for four years, allowing him some travel, but perhaps his stay in the army is what gave him inspiration for his socially aware paintings. In 1934, Luce was elected the President of the Société des Artistes Indépendents after the retirement of Paul Signac. However, he resigned soon after learning that the society had a policy of not allowing Jewish artists to participate.</p>
      <p class="wow fadeInLeft" data-wow-delay=".4s">Lithos were also a specialty of Luce’s. He was initially trained in wood carving at the Ecole des Arts decoratifs, and before his military service worked as an engraver. He would also sketch in charcoal on paper, and was a master draftsman. Some of Luce’s most famous factory scenes were lithographs such as this one entitled “Les Usines” (1898). His use of light is typical of Pointillism methods, but he still shows a great talent for the use of light by making the foreground dark and the background illuminated.</p>
      <p  class="wow fadeInRight" data-wow-delay=".4s"><img border="0" src="uploads/artists/artists_l-z/luce/Luce_LesUsines.jpg" alt="art" width="auto" height="auto"></p>
      <div class="boldcap wow fadeInRight" data-wow-delay=".4s">Les Usines</div>
      <p class="wow fadeInLeft" data-wow-delay=".4s">Some of Luce’s lithographs are indeed his finest work. Note in this crayon lithograph portrait of his friend “Camille Pissaro” (1890) the Realist method used for the subject but a much looser method for the background.</p>
      <p  class="wow fadeInRight" data-wow-delay=".4s"><img border="0" src="uploads/artists/artists_l-z/luce/luce_pissaro.jpg" alt="art" width="auto" height="auto"></p>
      <div class="boldcap wow fadeInRight" data-wow-delay=".4s">Camille Pissaro</div>
      <p class="wow fadeInLeft" data-wow-delay=".4s">Something remarkable about Luce was that he was at times regimented, and at other times was an experimental jet setter. While his style of Pointillism required him to be precise and mathematical, he later on adopted a looser style in his lithographs. He would also paint regimented street scenes, but also went outside the box and painted scenes with social meaning. He was even known to sign his lithographs in red chalk!</p>
      <p class="wow fadeInLeft" data-wow-delay=".4s">Luce also left us a few mysteries regarding his portraits. He would sometimes just stamp them as “Portrait d’homme” (portrait of a man), and not leave the name of his subject. Luce was friendly with many French artists and the upper crust, so it’s possible that his portraits could have been of a historical figure. One such portrait is thought to be of sculptor Andre Millet. Could he also have forgotten to add his signature to certain pieces?</p>
      <p class="wow fadeInLeft" data-wow-delay=".4s">Maximilien Luce’s was an experimental artist who helped to bring Pointillism to life. He worked in many different mediums and a few different styles, and changed his color palate often from light and dark to warm and cool. He favored landscapes and social scenes, though now and then, he would paint something surprising and different.</p>
      <p class="wow fadeInLeft" data-wow-delay=".4s">Not sure if you own a Luce original? Only an expert can tell for sure. We will be happy to consult you.</p>
      
      
    </div>
    
    
    <?php include($_SERVER['DOCUMENT_ROOT']."/includes/right-sidebar.php");  ?>
    
    <!-- / main body -->

  </main>
</div>



<?php include($_SERVER['DOCUMENT_ROOT']."/includes/footer.php");  ?>



<?php include($_SERVER['DOCUMENT_ROOT']."/includes/copyright.php");  ?>


<a id="backtotop" href="#top"><i class="fa fa-chevron-up"></i></a>
<!-- JAVASCRIPTS -->
<script src="../layout/scripts/jquery.min.js"></script>
<script src="../layout/scripts/jquery.backtotop.js"></script>
<script src="../layout/scripts/jquery.mobilemenu.js"></script>
<script src="https://cdn.jsdelivr.net/npm/cookieconsent@3/build/cookieconsent.min.js" data-cfasync="false"></script>
<script>
window.cookieconsent.initialise({
  "palette": {
    "popup": {
      "background": "#474747"
    },
    "button": {
      "background": "#9d0552"
    }
  },
  "content": {
    "message": "This website uses cookies to improve your experience. We'll assume you're ok with this, but you can opt-out if you wish.",
    "dismiss": "Accept Cookies"
  }
});
</script>

</body>
</html>