<!DOCTYPE html>

<html lang="en">
<!-- To declare your language - read more here: https://www.w3.org/International/questions/qa-html-language-declarations -->
<head>
<title>Andrea Mantegna | Art Experts</title>
<meta name="description" content="Andrea Mantegna art authentication, Andrea Mantegna appraisal, Full painting authentications. Certificate of authenticity (COA). we will sell your Andrea Mantegna.">
<meta name=”robots” content="index, follow">





















<link href="../layout/styles/test-layout.css" rel="stylesheet" type="text/css" media="all">
<link rel="stylesheet" type="text/css" href="https://cdn.jsdelivr.net/npm/cookieconsent@3/build/cookieconsent.min.css" />
<!-- Global site tag (gtag.js) - Google Analytics -->
<script async src="https://www.googletagmanager.com/gtag/js?id=G-NZ7GKNVDYS"></script>
<script>
  window.dataLayer = window.dataLayer || [];
  function gtag(){dataLayer.push(arguments);}
  gtag('js', new Date());

  gtag('config', 'G-NZ7GKNVDYS');
</script>
<link rel="canonical" href="<?php echo 'https://' . $_SERVER['HTTP_HOST'] . $_SERVER['REQUEST_URI']; ?>"><meta name="viewport" content="width=device-width, initial-scale=1.0"></head>

<?php include($_SERVER['DOCUMENT_ROOT']."/includes/header2.php");  ?>
<!-- ################################################################################################ -->
<!-- ################################################################################################ -->
<!-- ################################################################################################ -->
<div class="wrapper bgded overlay" style="display:none;background-image:url(../images/demo/backgrounds/09.png);">
  <div id="breadcrumb" class="hoc clear"> 
    <!-- ################################################################################################ -->
    <!-- ################################################################################################ -->
  </div>
</div>
<!-- ################################################################################################ -->
<!-- ################################################################################################ -->
<!-- ################################################################################################ -->
<div class="wrapper row3">
  <main class="hoc container clear"> 
    <!-- main body -->
    <!-- ################################################################################################ -->
    <div class="content three_quarter first" id="three_connn"> 
      <!-- ################################################################################################ -->

      
      
      <div>
        <h1 class="wow fadeInLeft" data-wow-delay=".4s">Andrea Mantegna (1431 – 1506)</h1>
      </div>
      <p class="wow fadeInLeft" data-wow-delay=".4s" align="justify">Andrea Mantegna art authentication. <a href="https://www.artexpertswebsite.com/appraisal/painting-appraisal.php">Andrea Mantegna appraisal</a>. <a href="https://www.artexpertswebsite.com/authentication/certificate-of-authenticity.php">Andrea Mantegna certificates of authenticity (COA)</a>.  Andrea Mantegna analysis, <a href="https://www.artexpertswebsite.com/authentication/provenance-research.php">research</a>, <a href="https://www.artexpertswebsite.com/authentication/scientific-tests.php">scientific tests</a>, <a href="https://www.artexpertswebsite.com/authentication.php">full art authentications</a>. We will help you sell your Andrea Mantegna or we will sell it for you.</p>
      <p  class="wow fadeInRight" data-wow-delay=".4s"><img src="uploads/artists/artists_l-z/mantegna/Mantegna_PortraitOfCarloDeMedici.jpg" alt="art" width="auto" height="auto"></p>
      <div class="boldcap wow fadeInRight" data-wow-delay=".4s">Portrait of Carlo de’ Medici 1467</div>
      <p class="wow fadeInLeft" data-wow-delay=".4s" align="justify">Andrea Mantegna was an Italian Renaissance artist. Mantegna was a serious student of Roman archaeology and son-in-law of Jacopo Bellini. Like other artists of the time, Mantegna experimented with perspective as he thought best, e.g., by lowering the horizon in order to create a sense of greater monumentality. His flinty, metallic landscapes and somewhat stony figures give evidence of a fundamentally sculptural approach to painting. He led a workshop that was the leading producer of prints in Italy before 1500.</p>
      <p  class="wow fadeInRight" data-wow-delay=".4s"><img src="uploads/artists/artists_l-z/mantegna/Mantegna_AgonyInTheGarden.jpg" alt="art" width="auto"></p>
      <div class="boldcap wow fadeInRight" data-wow-delay=".4s">The Agony in the Garden 1455</div>
      <p class="wow fadeInLeft" data-wow-delay=".4s">Mantegna was born in Isola di Carturo, close to Padua in the Republic of Venice, second son of a carpenter, Biagio. At the age of eleven he became the apprentice of Francesco Squarcione, Paduan painter. Squarcione, whose original vocation was tailoring, appears to have had a remarkable enthusiasm for ancient art, and a faculty for acting. Like his famous compatriot Petrarca, Squarcione was something of a fanatic for ancient Rome: he travelled in Italy, and perhaps Greece, collecting antique statues, reliefs, vases, etc., forming a collection of such works, making drawings from them himself, and throwing open his stores for others to study from, and then undertaking works on commission for which his pupils no less than himself were made available. As many as 137 painters and pictorial students passed through his school, established towards 1440 and which became famous all over Italy. Mantegna was Squarcione’s favorite pupil. Squarcione taught Mantegna the Latin language and instructed him to study fragments of Roman sculpture. He also preferred forced perspective.</p>
      <p class="wow fadeInLeft" data-wow-delay=".4s">Mantegna at the age of 17 separated himself from Squarcione. He later claimed that Squarcione had profited from his work without paying the rights. Padua was attractive for artists coming not only from Veneto but also from Toscana: such as Paolo Uccello, Filippo Lippi and Donatello. Mantegna’s early career was shaped indeed by impressions of Florentine works.</p>
      <p  class="wow fadeInRight" data-wow-delay=".4s"><img src="uploads/artists/artists_l-z/mantegna/Mantegna_FrescoDetail.jpg" alt="art" width="auto" height="auto"></p>
      <div class="boldcap wow fadeInRight" data-wow-delay=".4s">Fresco Detail</div>
      <p class="wow fadeInLeft" data-wow-delay=".4s">His first work, now lost, was an altarpiece for the church of Santa Sofia in 1448. The same year Mantegna was called, together with Nicolò Pizolo, to work with a large group of painters entrusted with the decoration of the Ovetari Chapel in the abside of the church of Eremitani. After a series of coincidences, Mantegna finished most of the work alone. This work was almost lost in the 1944 Allied bombings of Padua. The most dramatic work of the fresco cycle was the work set in the worm’s-eye view perspective, St. James Led to His Execution. The sketch of this fresco survived and is the earliest known preliminary sketch which still exists to compare to the corresponding fresco. Despite the authentic look of the monument, it is not a copy of any known Roman structure. Mantegna also adopted the wet drapery patterns of the Romans, who derived the form from the Greek invention, for the clothing of his figures, although the tense figures and interactions are derived from Donatello. The drawing shows proof that nude figures were used in the conception of works during the Early Renaissance. In the preliminary sketch, the perspective is less developed and closer to a more average viewpoint however. This worm’s eye perspective, creating an effectively large and prominent setting, is also seen in his work The Holy Trinity with the Virgin, St. John, and Two Donors. Ansuino, who collaborated with Mantegna in the Ovetari Chapel, brought his style in the Forlì school of painting.</p>
      <p class="wow fadeInLeft" data-wow-delay=".4s">As the youth progressed in his studies, he came under the influence of Jacopo Bellini, father of the celebrated painters Giovanni and Gentile, and of a daughter Nicolosia; and in 1453 Jacopo gave Nicolosia to Mantegna in marriage.</p>
      <p class="wow fadeInLeft" data-wow-delay=".4s">Among the other early Mantegna frescoes are the two saints over the entrance porch of the church of Sant’Antonio in Padua, 1452, and an altar-piece of St Luke and other saints for the church of S. Giustina, now in the Brera Gallery in Milan (1453). It is probable, however, that before this time some of the pupils of Squarcione, including Mantegna, had already begun that series of frescoes in the chapel of S. Cristoforo, in the church of Sant’Agostino degli Eremitani, now considered his masterpiece. The now censorious Squarcione carped about the earlier works of this series, illustrating the life of St James; he said the figures were like men of stone, and had better have been colored stone-color at once.</p>
      <p class="wow fadeInLeft" data-wow-delay=".4s">Andrea seems to have been influenced by his old preceptor’s strictures; and the later subjects, from the legend of St Christopher, combine with his other excellences more of natural character and vivacity. Trained as he had been to the study of marbles and the severity of the antique, and openly avowing that he considered the antique superior to nature as being more eclectic in form, he now and always affected precision of outline, dignity of idea and of figure, and he thus tended towards rigidity, and to an austere wholeness rather than gracious sensitiveness of expression. His draperies are tight and closely folded, being studied (it is said) from models draped in paper and woven fabrics gummed. Figures slim, muscular and bony, action impetuous but of arrested energy, tawny landscape, gritty with littering pebbles, mark the athletic hauteur of his style. He never changed the manner which he had adopted in Padua; his coloring, at first neutral and undecided, strengthened and matured. There is throughout his works more balancing of color than fineness of tone. One of his great aims was optical illusion, carried out by a mastery of perspective which, though not always impeccably correct, nor absolutely superior in principle to the highest contemporary point of attainment, was worked out by himself with strenuous labor, and an effect of actuality astonishing in those times.</p>
      <p  class="wow fadeInRight" data-wow-delay=".4s"><img src="uploads/artists/artists_l-z/mantegna/Mantegna_FrescoDetail2.jpg" alt="art" width="auto"></p>
      <div class="boldcap wow fadeInRight" data-wow-delay=".4s">Fresco Detail 2</div>
      <p class="wow fadeInLeft" data-wow-delay=".4s">Successful and admired though he was there, Mantegna left his native Padua at an early age, and never resettled there again; the hostility of Squarcione has been assigned as the cause. He spent the rest of his life in Verona, Mantua and Rome; it has not been confirmed that he also stayed in Venice and Florence. In Verona around 1459, he painted, a grand altarpiece for the church of San Zeno Maggiore, a Madonna and angels, with four saints on each side.</p>
      <p class="wow fadeInLeft" data-wow-delay=".4s">The Marquis Ludovico II Gonzaga of Mantua had for some time been pressing Mantegna to enter his service; and the following year, 1460 Mantegna was appointed court artist. He resided at first from time to time at Goito, but, from December 1466 onwards, he moved with his family to Mantua. His engagement was for a salary of 75 lire a month, a sum so large for that period as to mark conspicuously the high regard in which his art was held. He was in fact the first painter of any eminence ever domiciled in Mantua.</p>
      <p  class="wow fadeInRight" data-wow-delay=".4s"><img src="uploads/artists/artists_l-z/mantegna/Mantegna_AllegoricalDanceOfWomen.jpg" alt="art" width="auto"></p>
      <div class="boldcap wow fadeInRight" data-wow-delay=".4s">Allegorical Dance of Women 1497</div>
      <p class="wow fadeInLeft" data-wow-delay=".4s">His Mantuan masterpiece were painted in the apartment of the Castle of the city, today known as Camera degli Sposi (literally, “Wedding Chamber”): a series of full compositions in fresco including various portraits of the Gonzaga family and some figures of genii.</p>
      <p class="wow fadeInLeft" data-wow-delay=".4s">The Chamber’s decoration was finished presumably in 1474. The ten years that followed were not happy ones for Mantegna and Mantua: his character grew irritable, his son Bernardino died, as well as the marquis Ludovico, his wife Barbara and his successor Federico (who had declared Mantegna cavaliere, “knight” ). Only with the election of Francesco II of Gonzaga did the artistic commissions in Mantua begin again. He built a stately house in the area of the church of San Sebastiano, and adorned it with a multitude of paintings. The house can be still seen today, although the pictures have perished. In this period he began to collect some ancient Roma busts (which were donated to Lorenzo de Medici when the Florentine leader visited Mantua in 1483), painted some architectonical and decorational fragments, and finished the intense St. Sebastian now in the Louvre.</p>
      <p  class="wow fadeInRight" data-wow-delay=".4s"><img src="uploads/artists/artists_l-z/mantegna/Mantegna_MadonnaOfTheCherubim.jpg" alt="art" width="auto" height="auto"></p>
      <div class="boldcap wow fadeInRight" data-wow-delay=".4s">Madonna of the Cherubim 1485</div>
      <p class="wow fadeInLeft" data-wow-delay=".4s">In 1488 Mantegna was called by Pope Innocent VIII to paint frescos in a chapel Belvedere in the Vatican. This series of frescos, including a noted Baptism of Christ, was destroyed by Pius VI in 1780. The pope treated Mantegna with less liberality than he had been used to at the Mantuan court; but all things considered their connection, which ceased in 1500, was not unsatisfactory to either party. Mantegna also met the famous Turkish hostage Jem and studied with attention the ancient monuments, but his impression of the city was a disappointing one as a whole. Returned to Mantua in 1490, he embraced again his more literary and bitter vision of antiquity, and entered in strong connection with the new marquise, the cultured and intelligent Isabella d’Este.</p>
      <p class="wow fadeInLeft" data-wow-delay=".4s">In what was now his city he went on with the nine tempera pictures of the Triumphs of Caesar, which he had probably begun before his leaving for Rome, and which he finished around 1492. These superbly invented and designed compositions are gorgeous with the splendour of their subject-matter, and with the classical learning and enthusiasm of one of the master-spirits of the age. Considered Mantegna’s finest work, they were sold in 1628 along with the bulk of the Mantuan art treasures to King Charles I of England. They are now in Hampton Court Palace, somewhat faded, but many repaintings have been removed in a recent restoration. His workshop produced a series of engravings after them, which largely account for their rapid fame throughout Europe.</p>
      <p  class="wow fadeInRight" data-wow-delay=".4s"><img src="uploads/artists/artists_l-z/mantegna/Mantegna_BacchanalWithAVine.jpg" alt="art" width="auto"></p>
      <div class="boldcap wow fadeInRight" data-wow-delay=".4s">Bacchanal with a Vine Engraving</div>
      <p class="wow fadeInLeft" data-wow-delay=".4s">In spite of declining health, Mantegna continued to be active. Other works of this period include the Madonna of the Caves, the St. Sebastian and the famous Lamentation over the Dead Christ, probably painted for his personal funerary chapel. Another work of Mantegna’s later years was the so-called Madonna della Vittoria, now in the Louvre. It was painted in tempera about 1495, in commemoration of the Battle of Fornovo, whose disputable outcome Francesco Gonzaga was eager to show as an Italian League victory; the church which originally housed the picture was built from Mantegnas own design. The Madonna is here depicted with various saints, the archangel Michael and St. Maurice holding her mantle, which is extended over the kneeling Francesco Gonzaga, amid a profusion of rich festooning and other accessory. Though not in all respects of his highest order of execution, this counts among the most obviously beautiful and attractive of Mantegnas works from which the qualities of beauty and attraction are often excluded, in the stringent pursuit of those other excellences more germane to his severe genius, tense energy passing into haggard passion.</p>
      <p class="wow fadeInLeft" data-wow-delay=".4s">After 1497 Mantegna was commissioned by Isabella d’Este to translate the mythological themes written by the court poet Paride Ceresara into paintings for her private apartment (studiolo) in the Palazzo Ducale. These paintings were dispersed in the following years: one of them, the legend of the God Comus, was left unfinished by Mantegna and completed by his successor as court painter in Mantua, Lorenzo Costa.</p>
      <p class="wow fadeInLeft" data-wow-delay=".4s">After the death of his wife, Mantegna became at an advanced age the father of a natural son, Giovanni Andrea; and at the last, although he continued launching out into various expenses and schemes, he had serious tribulations, such as the banishment from Mantua of his son Francesco, who had incurred the marquis’ displeasure. Perhaps the aged master and connoisseur regarded as barely less trying the hard necessity of parting with a beloved antique bust of Faustina.</p>
      <p  class="wow fadeInRight" data-wow-delay=".4s"><img src="uploads/artists/artists_l-z/mantegna/Mantegna_LamentationOverTheDeadChrist.jpg" alt="art" width="auto"></p>
      <div class="boldcap wow fadeInRight" data-wow-delay=".4s">Lamentation Over the Dead Christ</div>
      <p class="wow fadeInLeft" data-wow-delay=".4s">Very soon after this transaction he died in Mantua, on September 13, 1506. In 1516 a handsome monument was set up to him by his sons in the church of Sant’Andrea, where he had painted the altar-piece of the mortuary chapel. The dome is decorated by Correggio.</p>
      <p  class="wow fadeInRight" data-wow-delay=".4s"><img src="uploads/artists/artists_l-z/mantegna/Mantegna_TheHolyFamily.jpg" alt="art" width="auto" height="auto"></p>
      <div class="boldcap wow fadeInRight" data-wow-delay=".4s">The Holy Family</div>
      <p class="wow fadeInLeft" data-wow-delay=".4s">Mantegna was no less eminent as an engraver, though his history in that respect is somewhat obscure, partly because he never signed or dated any of his plates, but for a single disputed instance of 1472. The account which has come down to us from Vasari (as usual keen to assert that everything flows from Florence) is that Mantegna began engraving in Rome, prompted by the engravings produced by the Florentine Baccio Baldini after Sandro Botticelli. This is now considered most unlikely as it would consign all the numerous and elaborate engravings made by Mantegna to the last sixteen or seventeen years of his life, which seems a scanty space for them, and besides the earlier engravings indicate an earlier period of his artistic style. He may have begun engraving while still in Padua, under the tuition of a distinguished goldsmith, Niccolò. He and his workshop engraved about thirty plates, according to the usual reckoning; large, full of figures, and highly studied. It is now considered either that he only engraved seven himself, or none. Another artist from the workshop who made several plates is usually identified as Zoan Andrea.</p>
      <p class="wow fadeInLeft" data-wow-delay=".4s">Among the principal examples are: Battle of the Sea Monsters,Virgin and Child, a Bacchanal Festival, Hercules and Antaeus, Marine Gods, Judith with the Head of Holophernes, the Deposition from the Cross, the Entombment, the Resurrection, the Man of Sorrows, the Virgin in a Grotto, and several scenes from the Triumph of Julius Caesar after his paintings. Several of his engravings are supposed to be executed on some metal less hard than copper. The technique of himself and his followers is characterized by the strongly marked forms of the design, and by the oblique formal hatchings of the shadows. The prints are frequently to be found in two states, or editions. In the first state the prints have been taken off with the roller, or even by handpressing, and they are weak in tint; in the second state the printing press has been used, and the ink is stronger. Neither Mantegna or his workshop are now believed to have produced the so-called Mantegna Tarocchi cards.</p>
      <p  class="wow fadeInRight" data-wow-delay=".4s"><img src="uploads/artists/artists_l-z/mantegna/Mantegna_TheCourtOfMantua.jpg" alt="art" width="auto"></p>
      <div class="boldcap wow fadeInRight" data-wow-delay=".4s">The Court of Mantua</div>
      <p class="wow fadeInLeft" data-wow-delay=".4s">Giorgio Vasari eulogizes Mantegna, although pointing out his litigious character. He had been fond of his fellow-pupils at Padua: and for two of them, Dario da Trevigi and Marco Zoppo, he retained a steady friendship. Mantegna became very expensive in his habits, fell at times into difficulties, and had to urge his valid claims upon the marquis’ attention.</p>
      <p class="wow fadeInLeft" data-wow-delay=".4s">In solid antique taste, Mantegna distanced all contemporary competition. Though substantially related to the 15th century, the influence of Mantegna on the style and tendency of his age was very marked over Italian art generally. Giovanni Bellini, in his earlier works, obviously followed the lead of his brother-in-law Andrea. Albrecht Dürer was influenced by his style during his two trips in Italy. Leonardo da Vinci took from Mantegna the use of decorations with festoons and fruit.</p>
      <p  class="wow fadeInRight" data-wow-delay=".4s"><img src="uploads/artists/artists_l-z/mantegna/Mantegna_TheAdorationOfTheShepherds.jpg" alt="art" width="auto"></p>
      <div class="boldcap wow fadeInRight" data-wow-delay=".4s">The Adoration of the Shepherds</div>
      <p class="wow fadeInLeft" data-wow-delay=".4s">Mantegna’s main legacy in considered the introduction of spatial illusionism, both in frescoes and in sacra conversazione paintings: his tradition of ceiling decoration was followed for almost three centuries. Starting from the faint cupola of the Camera degli Sposi, Correggio brought on his master and collaborator’s research in perspective constructions, producing eventually a masterwork like the dome of Cathedral of Parma.</p>
      <p class="wow fadeInLeft" data-wow-delay=".4s">Major works</p>
      <p class="wow fadeInLeft" data-wow-delay=".4s">• St. Jerome in the Wilderness (c. 1448-1451) – Tempera on wood, 48 x 36 cm, São Paulo Art Museum, São Paulo, Brazil<br>
        • The Adoration of the Shepherds (c. 1451-1453) – Tempera on canvas transferred from wood, 40 x 55,6 cm, Metropolitan Museum of Art, New York<br>
        • Crucifixion (1457-1459) – Wood, 67 x 93 cm, Louvre, Paris<br>
        • Christ as the Suffering Redeemer (1495-1500) – Tempera on wood, 78 x 48 cm, Statens Museum for Kunst, Copenhagen<br>
        • Agony in the Garden (c. 1459) – Tempera on wood, 63 x 80 cm, National Gallery, London<br>
        • Portrait of Cardinal Lodovico Trevisano, (c. 1459-1469) – Tempera on wood, 44 x 33 cm, Staatliche Museen, Berlin<br>
        • San Luca Altarpiece (1453) – Panel, 177 x 230 cm, Pinacoteca di Brera, Milan<br>
        • Death of the Virgin (c. 1461) – Panel, 54 x 42 cm, Museo del Prado, Madrid<br>
        • Portrait of a Man (c. 1460) – Wood, National Gallery of Art, Washington<br>
        • Presentation at the Temple (c. 1460-1466) – Tempera on wood, 67 x 86 cm, Staatliche Museen, Berlin<br>
        • Madonna with Sleeping Child (c.1465-1470) – Oil on canvas, 43×32 cm, Staatliche Museen, Berlin<br>
        • St. George (c. 1460) – Tempera on panel, 66 x 32 cm, Gallerie dell’Accademia, Venice<br>
        • Altarpiece of San Zeno (1457-1460) – Panel, 480 x 450 cm, San Zeno, Verona<br>
        • St. Sebastian (c. 1457-1459)- Wood, 68 x 30 cm, Kunsthistorisches Museum, Vienna<br>
        • St. Sebastian – Panel, 255 x 140 cm, Louvre, Paris<br>
        • Portrait of Carlo de Medici (c. 1467) – Tempera on panel, 40.6 x 29.5 cm, Uffizi, Florence<br>
        • The Madonna of the Cherubim (c. 1485) – Panel, 88 x 70 cm, Pinacoteca di Brera, Milan<br>
        • Triumph of Caesar (c. 1486) – Hampton Court Palace, England<br>
        • The Lamentation over the Dead Christ (c. 1490) – Tempera on canvas, 68 x 81 cm, Pinacoteca di Brera, Milan<br>
        • Madonna of the Caves (1489-1490)) – Uffizi, Florence<br>
        • St. Sebastian (1490) – Ca’ d’Oro, Venice<br>
        • Madonna della Vittoria (1495) – Oil on canvas, 285 x 168 cm, Louvre, Paris<br>
        • Holy Family (c. 1495-1500) – Tempera on canvas, 75.5 x 61.5 cm, The Dresden Gallery, Dresden<br>
        • Judith and Holofernes (1495) – Egg-tempera on wood, National Gallery of Art, Washington<br>
        • Minerva Chases the Vices from the Garden of Virtue (c. 1502)- Oil on canvas, 160×192 cm, Louvre, Paris<br>
        • Parnassus (Mars and Venus) (1497) – Canvas, 160 x 192 cm, Louvre, Paris</p>
      <p  class="wow fadeInRight" data-wow-delay=".4s"><img src="uploads/artists/artists_l-z/mantegna/Mantegna_SampsonAndDelilah.jpg" alt="art" width="auto"></p>
      <div class="boldcap wow fadeInRight" data-wow-delay=".4s">Samson and Delilah</div>
      <p class="wow fadeInLeft" data-wow-delay=".4s">Still wondering about an Italian painting in your family collection? <a href="https://www.artexpertswebsite.com/contact/contact1.php">Contact us</a>…it could be by Andrea Mantegna.</p>
      
      <!-- ################################################################################################ -->
    </div>
    <!-- ################################################################################################ -->
    <!-- ################################################################################################ -->
    <?php include($_SERVER['DOCUMENT_ROOT']."/includes/right-sidebar.php");  ?>
    <!-- ################################################################################################ -->
    <!-- / main body -->

  </main>
</div>
<!-- ################################################################################################ -->
<!-- ################################################################################################ -->
<!-- ################################################################################################ -->
<?php include($_SERVER['DOCUMENT_ROOT']."/includes/footer.php");  ?>
<!-- ################################################################################################ -->
<!-- ################################################################################################ -->
<!-- ################################################################################################ -->
<?php include($_SERVER['DOCUMENT_ROOT']."/includes/copyright.php");  ?><!-- ################################################################################################ -->
<!-- ################################################################################################ -->
<!-- ################################################################################################ -->
<a id="backtotop" href="#top"><i class="fa fa-chevron-up"></i></a>
<!-- JAVASCRIPTS -->
<script src="../layout/scripts/jquery.min.js"></script>
<script src="../layout/scripts/jquery.backtotop.js"></script>
<script src="../layout/scripts/jquery.mobilemenu.js"></script>
<script src="https://cdn.jsdelivr.net/npm/cookieconsent@3/build/cookieconsent.min.js" data-cfasync="false"></script>
<script>
window.cookieconsent.initialise({
  "palette": {
    "popup": {
      "background": "#474747"
    },
    "button": {
      "background": "#9d0552"
    }
  },
  "content": {
    "message": "This website uses cookies to improve your experience. We'll assume you're ok with this, but you can opt-out if you wish.",
    "dismiss": "Accept Cookies"
  }
});
</script>

</body>
</html>