<!DOCTYPE html>

<html lang="en">
<!-- To declare your language - read more here: https://www.w3.org/International/questions/qa-html-language-declarations -->
<head>
<title>Domingo Ravenet | Art Experts</title>
<meta name="description" content="Domingo Ravenet art authentication, Domingo Ravenet appraisal, Full painting authentications. Certificate of authenticity (COA). we will sell your Domingo Ravenet.">
<meta name=”robots” content="index, follow">





















<link href="../layout/styles/test-layout.css" rel="stylesheet" type="text/css" media="all">
<link rel="stylesheet" type="text/css" href="https://cdn.jsdelivr.net/npm/cookieconsent@3/build/cookieconsent.min.css" />
<!-- Global site tag (gtag.js) - Google Analytics -->
<script async src="https://www.googletagmanager.com/gtag/js?id=G-NZ7GKNVDYS"></script>
<script>
  window.dataLayer = window.dataLayer || [];
  function gtag(){dataLayer.push(arguments);}
  gtag('js', new Date());

  gtag('config', 'G-NZ7GKNVDYS');
</script>
<link rel="canonical" href="<?php echo 'https://' . $_SERVER['HTTP_HOST'] . $_SERVER['REQUEST_URI']; ?>"><meta name="viewport" content="width=device-width, initial-scale=1.0"></head>

<?php include($_SERVER['DOCUMENT_ROOT']."/includes/header2.php");  ?>



<div class="wrapper bgded overlay" style="display:none;background-image:url(../images/demo/backgrounds/09.png);">
  <div id="breadcrumb" class="hoc clear"> 
    
    
  </div>
</div>



<div class="wrapper row3">
  <main class="hoc container clear"> 
    <!-- main body -->
    
    <div class="content three_quarter first" id="three_connn"> 
      

      
      
      <div>
        <h1 class="wow fadeInLeft" data-wow-delay=".4s">Domingo Ravenet (1905-1969)</h1>
      </div>
      <p  class="wow fadeInRight" data-wow-delay=".4s"><img border="0" src="uploads/artists/artists_l-z/ravenet/Ravenet_SelfPortrait.jpg" alt="art" width="auto" height="auto"></p>
      <div class="boldcap wow fadeInRight" data-wow-delay=".4s">Self-Portrait</div>
      <p class="wow fadeInLeft" data-wow-delay=".4s">Of all of the Cuban artists to come from the turn of the century, Domingo Ravenet has been called the voice of the Cuban Avant-Guard. A masterful artist, Ravenet dabbled in everything from writing to teaching, and was also a curator. However, it is his artwork that still remains and proves him as the true Renaissance man. Among many other things, Ravenet has also been called a pioneer in modern frescoes and mural art among Cuban artists.</p>
      <p class="wow fadeInLeft" data-wow-delay=".4s">Ravenet was born in Valencia, Spain, but grew up in Havana. Among his many talents, Ravenet was a painter, sculptor, illustrator and a muralist. Schooled at the San Alejandro Academy, Ravenet graduated Cum Laude. From that point on, Ravenet dedicated his life to becoming a teacher and promoter of the arts. </p>
      <p  class="wow fadeInRight" data-wow-delay=".4s"><img border="0" src="uploads/artists/artists_l-z/ravenet/Ravenet_Raquel.jpg" alt="art" width="auto" height="auto"></p>
      <div class="boldcap wow fadeInRight" data-wow-delay=".4s">Raquel</div>
      <p class="wow fadeInLeft" data-wow-delay=".4s">Along with other Cuban artists of the time, Ravenet decided that he must go to Europe to continue his studies. Because of his Spanish/Cuban lineage, Ravenet often felt connected to both worlds. His sister, Elba Ramirez Corria said that “In him, one could appreciate both the most delicate nuances of tenderness and innocence and the most passionate explosions of his intense inner life. How could it not be so? Cuba and Spain were both present in the blood that ran through his veins!” This is extremely apparent in his art, as his style seems to marry that of the Avant Guard Europeans but with highly Cuban themes, compositions and subjects.</p>
      <p class="wow fadeInLeft" data-wow-delay=".4s">In Europe, Ravenet expanded his studies at the Academy Chaumiere de Paris. During this time, he was also able to study the old masters at the Louvre, and later, at the Prado in Madrid. He returned to Cuba in 1933, where he began to expose his work. In 1933, he also traveled to New York for further study. Like many of the Cuban artists that went to study in Europe, his time back at home in Cuba proved fruitful and he began painting typically “Cuban” themed compositions.</p>
      <p class="wow fadeInLeft" data-wow-delay=".4s">Some critics have compared the passionate brush strokes and bold color palate of Ravenet to that of the European Fauves. His painting “The Jaguey” (1938) which features a country road and farmhouse in the woods is very reminiscent of the style of Fauve painter Maurice de Vlaminck.</p>
      <p class="wow fadeInLeft" data-wow-delay=".4s">Ravenet’s paintings were almost always of idyllic images. About mid-career, Ravenet started painting in the Vanguard style of his contemporaries, painting “guarijo’s” and “campesino’s”—rural cowboys and farmhands of Cuba’s countryside. Usually, Ravenet’s style was more along the lines of painting an almost whimsical world. His portraits of women would usually be executed with idyllic backgrounds. He would also paint circus scenes, and pictures of mothers with their children. His work rarely had a somber or disturbing tone, but still managed to purvey a powerful message all the same.</p>
      <p  class="wow fadeInRight" data-wow-delay=".4s"><img border="0" src="uploads/artists/artists_l-z/ravenet/Ravenet_PictureOfAManInParis.jpg" alt="art" width="auto" height="auto"></p>
      <div class="boldcap wow fadeInRight" data-wow-delay=".4s">Picture of a Man in Paris</div>
      <p  class="wow fadeInRight" data-wow-delay=".4s"><img border="0" src="uploads/artists/artists_l-z/ravenet/Ravenet_Mayito.jpg" alt="art" width="auto" height="auto"></p>
      <div class="boldcap wow fadeInRight" data-wow-delay=".4s">Mayito</div>
      <p class="wow fadeInLeft" data-wow-delay=".4s">Though he worked in ceramics quite extensively, Ravenet was not well known for them. He would usually paint decorative pottery, cups and plates with very traditional Cuban styles. His ceramics were probably the most reflective area of his Cuban heritage, and the bright and tropical color palate he usually chose and native symbols he emblazoned on them were proof of this. His small ceramic statues were also reminiscent of primitive Cuba, and were usually very simple with fluid lined statues of people. Ravenet would also often work alongside Amelia Pelaéz as she made ceramics too.</p>
      <p class="wow fadeInLeft" data-wow-delay=".4s">In the past, Ravenet proved to be a very sought after artists when one of his works was stolen from an exhibit. An oil painting entitled “Ligeia” which was a small portrait of a woman, and was an award-winning piece. It was stolen in 1937, and reappeared in 1980, far after the artist’s death, and the pieces abductor and whereabouts for more than forty years still remains a mystery. Could there be other pieces like this in existence today?</p>
      <p class="wow fadeInLeft" data-wow-delay=".4s">Though he was a very popular artist in Cuba, sadly, little is known about this great artist worldwide. Ravenet traveled to Europe to study without the help of scholarships or a wealthy family, so it is quite likely that he sold his work to make a living in Europe. Truthfully, the possibility for finding one of his works in someone’s home or in Europe is outstanding. He also exhibited all over the United States from New York to California in the 1950s as well as throughout the Caribbean and in France, which makes an even greater likelihood for someone to privately own his work.</p>
      <p  class="wow fadeInRight" data-wow-delay=".4s"><img border="0" src="uploads/artists/artists_l-z/ravenet/Ravenet_Plate.jpg" alt="art" width="auto" height="auto"></p>
      <div class="boldcap wow fadeInRight" data-wow-delay=".4s">Plate</div>
      <p  class="wow fadeInRight" data-wow-delay=".4s"><img border="0" src="uploads/artists/artists_l-z/ravenet/Ravenet_Cup.jpg" alt="art" width="auto" height="auto"></p>
      <div class="boldcap wow fadeInRight" data-wow-delay=".4s">Cup</div>
      <p  class="wow fadeInRight" data-wow-delay=".4s"><img border="0" src="uploads/artists/artists_l-z/ravenet/Ravenet_Ceramic.jpg" alt="art" width="auto" height="auto"></p>
      <div class="boldcap wow fadeInRight" data-wow-delay=".4s">Ceramic</div>
      <p  class="wow fadeInRight" data-wow-delay=".4s"><img border="0" src="uploads/artists/artists_l-z/ravenet/Ravenet_Campesinos.jpg" alt="art" width="auto" height="auto"></p>
      <div class="boldcap wow fadeInRight" data-wow-delay=".4s">Campesinos</div>
      <p class="wow fadeInLeft" data-wow-delay=".4s">A very prolific painter, sadly and ironically, Ravenet was said to have died in front of his easel in Matanzas, Cuba. Today his work is housed worldwide in France, Canada, Russia, Brazil, Spain, The United States, Venezuela, Mexico and of course, Cuba.</p>
      
      
    </div>
    
    
    <?php include($_SERVER['DOCUMENT_ROOT']."/includes/right-sidebar.php");  ?>
    
    <!-- / main body -->

  </main>
</div>



<?php include($_SERVER['DOCUMENT_ROOT']."/includes/footer.php");  ?>



<?php include($_SERVER['DOCUMENT_ROOT']."/includes/copyright.php");  ?>


<a id="backtotop" href="#top"><i class="fa fa-chevron-up"></i></a>
<!-- JAVASCRIPTS -->
<script src="../layout/scripts/jquery.min.js"></script>
<script src="../layout/scripts/jquery.backtotop.js"></script>
<script src="../layout/scripts/jquery.mobilemenu.js"></script>
<script src="https://cdn.jsdelivr.net/npm/cookieconsent@3/build/cookieconsent.min.js" data-cfasync="false"></script>
<script>
window.cookieconsent.initialise({
  "palette": {
    "popup": {
      "background": "#474747"
    },
    "button": {
      "background": "#9d0552"
    }
  },
  "content": {
    "message": "This website uses cookies to improve your experience. We'll assume you're ok with this, but you can opt-out if you wish.",
    "dismiss": "Accept Cookies"
  }
});
</script>

</body>
</html>