<!DOCTYPE html>

<html lang="en">
<!-- To declare your language - read more here: https://www.w3.org/International/questions/qa-html-language-declarations -->
<head>
<title>Salvator Rosa | Art Experts</title>
<meta name="description" content="Salvator Rosa art authentication, Salvator Rosa appraisal, Full painting authentications. Certificate of authenticity (COA). we will sell your Salvator Rosa.">
<meta name=”robots” content="index, follow">





















<link href="../layout/styles/test-layout.css" rel="stylesheet" type="text/css" media="all">
<link rel="stylesheet" type="text/css" href="https://cdn.jsdelivr.net/npm/cookieconsent@3/build/cookieconsent.min.css" />
<!-- Global site tag (gtag.js) - Google Analytics -->
<script async src="https://www.googletagmanager.com/gtag/js?id=G-NZ7GKNVDYS"></script>
<script>
  window.dataLayer = window.dataLayer || [];
  function gtag(){dataLayer.push(arguments);}
  gtag('js', new Date());

  gtag('config', 'G-NZ7GKNVDYS');
</script>
<link rel="canonical" href="<?php echo 'https://' . $_SERVER['HTTP_HOST'] . $_SERVER['REQUEST_URI']; ?>"><meta name="viewport" content="width=device-width, initial-scale=1.0"></head>

<?php include($_SERVER['DOCUMENT_ROOT']."/includes/header2.php");  ?>
<!-- ################################################################################################ -->
<!-- ################################################################################################ -->
<!-- ################################################################################################ -->
<div class="wrapper bgded overlay" style="display:none;background-image:url(../images/demo/backgrounds/09.png);">
  <div id="breadcrumb" class="hoc clear"> 
    <!-- ################################################################################################ -->
    <!-- ################################################################################################ -->
  </div>
</div>
<!-- ################################################################################################ -->
<!-- ################################################################################################ -->
<!-- ################################################################################################ -->
<div class="wrapper row3">
  <main class="hoc container clear"> 
    <!-- main body -->
    <!-- ################################################################################################ -->
    <div class="content three_quarter first" id="three_connn"> 
      <!-- ################################################################################################ -->

      
      
      <div>
        <h1 class="wow fadeInLeft" data-wow-delay=".4s">Salvator Rosa (1615 – 1673)</h1>
      </div>
      <p class="wow fadeInLeft" data-wow-delay=".4s" align="justify">Do you think you may own a painting by Salvator Rosa? We perform <a href="https://www.artexpertswebsite.com/authentication.php">art art authentications</a>, <a href="https://www.artexpertswebsite.com/appraisal/painting-appraisal.php">art appraisals</a>, <a href="https://www.artexpertswebsite.com/authentication/provenance-research.php">art research</a> and <a href="https://www.artexpertswebsite.com/authentication/certificate-of-authenticity.php">Certificates of Authenticity</a> (COA) and provide free consultations for all paintings by Salvator Rosa.</p>
      <p  class="wow fadeInRight" data-wow-delay=".4s"><img src="uploads/artists/artists_l-z/rosa/Rosa_SelfPortrait1641.jpg" alt="art" width="auto"></p>
      <div class="boldcap wow fadeInRight" data-wow-delay=".4s">Self-Portrait 1641</div>
      <p class="wow fadeInLeft" data-wow-delay=".4s" align="justify">Salvator Rosa was an Italian Baroque painter, poet and printmaker, active in Naples, Rome and Florence. As a painter, he is best known as an “unorthodox and extravagant” and a “perpetual rebel” proto-Romantic. His life and writings were equally colorful.</p>
      <p class="wow fadeInLeft" data-wow-delay=".4s" align="justify">He was born in Arenella, in the outskirts of Naples: either June 20 or July 21, 1615. His father, Vito Antonio de Rosa, a land surveyor, urged his son to become a lawyer or a priest, and entered him into the convent of the Somaschi fathers. Yet, Salvator showed a preference for the arts, thus secretly worked with his maternal uncle Paolo Greco to learn about painting, and soon transferred himself to his own brother-in-law Francesco Francanzano, a pupil of Ribera, and afterwards to either Aniello Falcone, contemporary with Domenico Gargiulo, or Ribera himself. Some sources claim he spent time living with roving bandits. At the age of seventeen he lost his father; his mother was destitute with at least five children, and Salvator found himself without financial support.</p>
      <p  class="wow fadeInRight" data-wow-delay=".4s"><img src="uploads/artists/artists_l-z/rosa/Rosa_PortraitOfAMan.jpg" alt="art" width="auto"></p>
      <div class="boldcap wow fadeInRight" data-wow-delay=".4s">Portrait of a Man</div>
      <p class="wow fadeInLeft" data-wow-delay=".4s" align="justify">He continued apprenticeship with Falcone, aiding him complete his battlepiece canvases. In that studio, it is said that Lanfranco took notice of his work, and advised him to relocate to Rome, where he stayed for from 1634-6.</p>
      <p  class="wow fadeInRight" data-wow-delay=".4s"><img src="uploads/artists/artists_l-z/rosa/Rosalandscape.jpg" alt="art" width="auto" height="auto"></p>
      <div class="boldcap wow fadeInRight" data-wow-delay=".4s">Landscape</div>
      <p class="wow fadeInLeft" data-wow-delay=".4s" align="justify">Returning to Naples, he began painting haunting landscapes, overgrown with vegetation, or jagged beaches, mountains, and caves. Rosa was among the first to paint “romantic” landscapes, with a special turn for scenes of picturesque often turbulent and rugged scenes peopled with shepherds, brigands, seamen, soldiers. These early landscapes were sold cheaply through private dealers. This class of paintings peculiarly suited him.</p>
      <p  class="wow fadeInRight" data-wow-delay=".4s"><img src="uploads/artists/artists_l-z/rosa/Rosa_EveningLandscape.jpg" alt="art" width="auto"></p>
      <div class="boldcap wow fadeInRight" data-wow-delay=".4s">Evening Landscape</div>
      <p class="wow fadeInLeft" data-wow-delay=".4s" align="justify">He returned to Rome in 1638-39, where he was housed by Cardinal Francesco Maria Brancaccio, bishop of Viterbo. For the Chiesa Santa Maria della Morte in Viterbo, Rosa painted his first and one of his few altarpieces with an Incredulity of Thomas. While Rosa had a facile genius at painting, he pursued a wide variety of arts: music, poetry, writing, etching, and acting. In Rome, he befriended Pietro Testa and Claude Lorraine. During a Roman carnival play he wrote and acted in a masque, in which his character bustled about Rome distributing satirical prescriptions for diseases of the body and more particularly of the mind. In costume, he inveighed against the farcical comedies acted in the Trastevere under the direction of Bernini.</p>
      <p  class="wow fadeInRight" data-wow-delay=".4s"><img src="uploads/artists/artists_l-z/rosa/Rosa%20Land%20with%20figures.jpg" alt="art" width="auto"></p>
      <div class="boldcap wow fadeInRight" data-wow-delay=".4s">Landscape with Figures</div>
      <p class="wow fadeInLeft" data-wow-delay=".4s" align="justify">While his plays were successful, this also gained him powerful enemies among patrons and artists, including Bernini himself, in Rome. By late 1639, he had had to relocate to Florence, where he stayed for 8 years. He had been in part, invited by a Cardinal Giancarlo de Medici. Once there, Rosa sponsored a combination of studio and salon of poets, playwrights, and painters –the so called Accademia dei Percossi (“Academy of the Stricken”). To the rigid art milieu of Florence, he introduced his canvases of wild landscapes; while influential, he gathered few true pupils. Another painter poet, Lorenzo Lippi, shared with Rosa the hospitality of the cardinal and the same circle of friends. Lippi encouraged him to proceed with the poem Il Malmantile Racquistato. He was well acquainted also with Ugo and Giulio Maffei, and housed with them in Volterra, where he wrote four satires Music, Poetry, Painting and War. About the same time he painted his own portrait, now in the Uffizi Gallery.</p>
      <p  class="wow fadeInRight" data-wow-delay=".4s"><img src="uploads/artists/artists_l-z/rosa/ROsa_AFriarTemptedByDemons.jpg" alt="art" width="auto"></p>
      <div class="boldcap wow fadeInRight" data-wow-delay=".4s">A Friar Tempted by Demons 1660-1665</div>
      <p class="wow fadeInLeft" data-wow-delay=".4s" align="justify">In 1646 he returned to Naples, and appears to have sympathized with the insurrection of Masaniello, as a passage in one of his satires suggests. His actual participation in the revolt is dubious. It is alleged that Rosa, along with other painters–Coppola, Paolo Porpora, Domenico Gargiulo, Dal Po, Marzio Masturzo, the two Vaccari and Cadogna–all under the captaincy of Aniello Falcone, formed the Compagnia della Morte, whose mission it was to hunt down Spaniards in the streets, not sparing even those who had sought some place of religious asylum. He painted a portrait of Masaniello–probably from reminiscence rather than life. On the approach of Don Juan de Austria, the blood-stained Compagnia dispersed.</p>
      <p  class="wow fadeInRight" data-wow-delay=".4s"><img src="uploads/artists/artists_l-z/rosa/Rosa_AnchoritesTemptedByDemons.jpg" alt="art" width="auto"></p>
      <div class="boldcap wow fadeInRight" data-wow-delay=".4s">Anchorites Tempted by Demons</div>
      <p class="wow fadeInLeft" data-wow-delay=".4s" align="justify">Other tales tell that from there he escaped and joined with brigands in the Abruzzi. Although this incident which cannot be conveniently dove-tailed into known dates of his career, in 1846 a famous romantic ballet about this story titled Catarina was produced in London by the choreographer Jules Perrot and composer Cesare Pugni).</p>
      <p  class="wow fadeInRight" data-wow-delay=".4s"><img src="uploads/artists/artists_l-z/rosa/Rosa_LandscapeWStJohnTheBaptistPointingOutChrist.jpg" alt="art" width="auto"></p>
      <div class="boldcap wow fadeInRight" data-wow-delay=".4s">Landscape with St. John the Baptist Pointing out Christ 1655-1660</div>
      <p class="wow fadeInLeft" data-wow-delay=".4s" align="justify">Finally he returned to stay in Rome in 1649. Here he painted some important subjects, showing the uncommon bent of his mind as it passed from landscape into history Democritus amid Tombs, Death of Socrates, Regulus in the Spiked Cask (these two are now in England), Justice Quitting the Earth and the Wheel of Fortune. This last satirical work raised a storm of controversy. Rosa, endeavoring at conciliation, published a description of its meaning (probably softened down not a little from the real facts); none the less he was nearly arrested. It was about this time that Rosa wrote his satire named Babylon, under which name Rome was of course indicated.</p>
      <p  class="wow fadeInRight" data-wow-delay=".4s"><img src="uploads/artists/artists_l-z/rosa/Rosa_DemocritusInMeditation.jpg" alt="art" width="auto"></p>
      <div class="boldcap wow fadeInRight" data-wow-delay=".4s">Democritus in Meditation 1650s</div>
      <p class="wow fadeInLeft" data-wow-delay=".4s" align="justify">Much enmity still brooded there against him. An allegation arose that his published satires were not his own, but filched. Rosa indignantly denied the charges, although it is true that the satires ~deal so extensively and with such ready manipulation in classical names, allusions and anecdotes, that one is rather at a loss to fix upon the period of his busy career at which Rosa could possibly have imbued his mind with such a multitude of semi-erudite details. It may perhaps be legitimate to assume literary friends in Florence and Volterra coached him about the topic of his satires, as compositions, remaining none the less strictly and fully his own. To confute his detractors he now wrote the last of the series, entitled Envy.</p>
      <p  class="wow fadeInRight" data-wow-delay=".4s"><img src="uploads/artists/artists_l-z/rosa/Rosa_FigureSeenFromTheRear.jpg" alt="art" width="auto" height="auto"></p>
      <div class="boldcap wow fadeInRight" data-wow-delay=".4s">Figure Seen from the Rear, drawing</div>
      <p class="wow fadeInLeft" data-wow-delay=".4s" align="justify">Among the pictures of his last years were the admired Battlepiece and Saul and the Witch of Endor (latter perhaps final work) now in Louvre, painted in 40 days, full of longdrawn carnage, with ships burning in the offing; Pythagoras and the Fishermen; and the Oath of Catiline (Pitti Palace).</p>
      <p  class="wow fadeInRight" data-wow-delay=".4s"><img src="uploads/artists/artists_l-z/rosa/Rosa_SaulAtTheHouseofTheWitchOfEndor1668.jpg" alt="art" width="auto" height="auto"></p>
      <div class="boldcap wow fadeInRight" data-wow-delay=".4s">Saul and the Witch of Endor 1668</div>
      <p class="wow fadeInLeft" data-wow-delay=".4s" align="justify">While occupied with a series of satirical portraits, to be closed by one of himself, Rosa was assailed by dropsy. He died a half year later. In his last moments he married a Florentine named Lucrezia, who had borne him two sons, one of them surviving him, and he died in a contrite frame of mind. He lies buried in the Chiesa degli Angeli, where a portrait of him has been set up. Salvator Rosa, after struggles of his early youth, had successfully earned a handsome fortune.</p>
      <p class="wow fadeInLeft" data-wow-delay=".4s" align="justify">He was a significant etcher, with a highly popular and influential series of small prints of soldiers, and a number of larger and very ambitious subjects. Rosa was indisputably a leader in that tendency towards the romantic and picturesque. It is an open question how influential his work was in the following decades or in following centuries. Wittkower rightly states that it is his landscapes, not his grand historical or religious dramas, that Rosa truly expresses a novel and innate spark; he may have dismissed them as frivolous cappricci in comparison to his other themes, but these academically conventional canvases often restrained his rebellious streak. In general, in landscapes he avoided the idyllic and pastoral calm countrysides of Claude Lorraine and Paul Brill, and created brooding, melancholic fantasies, awash in ruins and brigands. The contrasts between the artists of his day is illustrated by the lines of Poetry written in 1748: Whate’er Lorraine light touched with softening hue/ Or savage Rosa dashed, or learned Poussin drew. He influenced Gaspar Dughet’s landscape style.</p>
      <p  class="wow fadeInRight" data-wow-delay=".4s"><img src="uploads/artists/artists_l-z/rosa/Rosa_Etching.jpg" alt="art" width="auto" height="auto"></p>
      <div class="boldcap wow fadeInRight" data-wow-delay=".4s">Etching</div>
      <p class="wow fadeInLeft" data-wow-delay=".4s" align="justify">In a time when artists where often highly constrained by patrons, Rosa had a plucky streak of independence, which celebrated the special role of the artist. Our wealth must consist in things of the spirit, and in contenting ourselves with sipping, while others gorge themselves in prosperity. He refused to paint on commission or to agree on a price beforehand, and he chose his own subjects. He painted in order to be carried away by the transports of enthusiasm and use my brushes only when I feel myself rapt. This tempestuous spirit became the darling of British Romantics.</p>
      <p  class="wow fadeInRight" data-wow-delay=".4s"><img src="uploads/artists/artists_l-z/rosa/Rosa_PortraitOfTheArtistsWifeLucrezia.jpg" alt="art" width="auto"></p>
      <div class="boldcap wow fadeInRight" data-wow-delay=".4s">Portrait of the Artists Wife Lucrezia</div>
      <p class="wow fadeInLeft" data-wow-delay=".4s" align="justify">The satires of Salvator Rosa deserve more attention than they have generally received. There are, however, two recent books taking account of them–by Cesareo, 1892, and Cartelli, 1899. The satires, though considerably spread abroad during his lifetime, were not published until 1719. They are all in terza rima, written without much literary correctness, but remarkably spirited, pointed and even brilliant. They are slashingly denunciatory, and from this point of view too monotonous in treatment. Rosa here appears as a very severe castigator of all ranks and conditions of men, not sparing the highest, and as a champion of the poor and down-trodden, and of moral virtue and Catholic faith. It seems odd that a man who took so free a part in the pleasures and diversions of life should be so ruthless to the ministers of these.</p>
      <p  class="wow fadeInRight" data-wow-delay=".4s"><img src="uploads/artists/artists_l-z/rosa/Rosa_ViewOfTheGulfOfSalerno.jpg" alt="art" width="auto"></p>
      <div class="boldcap wow fadeInRight" data-wow-delay=".4s">View of the Gulf of Salerno</div>
      <p class="wow fadeInLeft" data-wow-delay=".4s" align="justify">The satire on Music exposes the insolence and profligacy of musicians, and the shame of courts and churches in encouraging them. Poetry dwells on the pedantry, imitativeness, adulation, affectation and indecency of poets–also their poverty, and the neglect with which they were treated; and there is a very vigorous sortie against oppressive governors and aristocrats. Tasso’s glory is upheld; Dante is spoken of as obsolete, and Ariosto as corrupting.</p>
      <p  class="wow fadeInRight" data-wow-delay=".4s"><img src="uploads/artists/artists_l-z/rosa/Rosa_DiogenesCastingAwayHisCup.jpg" alt="art" width="auto" height="auto"></p>
      <div class="boldcap wow fadeInRight" data-wow-delay=".4s">Diogenes Casting Away his Cup 1650s</div>
      <p class="wow fadeInLeft" data-wow-delay=".4s" align="justify">Painting inveighs against the pictorial treatment of squalid subjects, such as beggars (though Rosa must surely himself have been partly responsible for this misdirection of the art), against the ignorance and lewdness of painters, and their tricks of trade, and the gross indecorum of painting sprawling half-naked saints of both sexes. War (which contains the eulogy of Masaniello) derides the folly of hireling Mter Focke soldiers, who fight and perish while kings stay at home; the vile morals of kings and lords, heresy and unbelief also come in for a flagellation.</p>
      <p  class="wow fadeInRight" data-wow-delay=".4s"><img src="uploads/artists/artists_l-z/rosa/Rosa_OdyssiusAndNausicaa.jpg" alt="art" width="auto"></p>
      <div class="boldcap wow fadeInRight" data-wow-delay=".4s">Odyssius and Nausicaa</div>
      <p class="wow fadeInLeft" data-wow-delay=".4s" align="justify">In Babylon ofrece Rosa represents himself as a fisherman, Tirreno, constantly unlucky in his net-hauls on the Euphrates; he converses with a native of the country, Ergasto. Babylon (Rome) is very severely treated, and Naples much the same.</p>
      <p  class="wow fadeInRight" data-wow-delay=".4s"><img src="uploads/artists/artists_l-z/rosa/Rosa_HarborWithRuins.jpg" alt="art" width="auto"></p>
      <div class="boldcap wow fadeInRight" data-wow-delay=".4s">Harbor with Ruins 1640-1643</div>
      <p class="wow fadeInLeft" data-wow-delay=".4s" align="justify">Envy (the last of the satires, and generally accounted the best, although without strong apparent reason) represents Rosa dreaming that, as he is about to inscribe in all modesty his name upon the threshold of the temple of glory, the goddess or fiend of Envy obstructs him, and a long interchange of reciprocal objurgations ensues. Here occurs the highly charged portrait of the chief Roman detractor of Salvator (we are not aware that he has ever been identified by name); and the painter protests that he would never condescend to do any of the lascivious work in painting so shamefully in vogue. Still wondering about an Italian painting in your family collection? <a href="https://www.artexpertswebsite.com/contact/contact1.php">Contact us</a>…it could be by Salvator Rosa.</p>
      
      <!-- ################################################################################################ -->
    </div>
    <!-- ################################################################################################ -->
    <!-- ################################################################################################ -->
    <?php include($_SERVER['DOCUMENT_ROOT']."/includes/right-sidebar.php");  ?>
    <!-- ################################################################################################ -->
    <!-- / main body -->

  </main>
</div>
<!-- ################################################################################################ -->
<!-- ################################################################################################ -->
<!-- ################################################################################################ -->
<?php include($_SERVER['DOCUMENT_ROOT']."/includes/footer.php");  ?>
<!-- ################################################################################################ -->
<!-- ################################################################################################ -->
<!-- ################################################################################################ -->
<?php include($_SERVER['DOCUMENT_ROOT']."/includes/copyright.php");  ?><!-- ################################################################################################ -->
<!-- ################################################################################################ -->
<!-- ################################################################################################ -->
<a id="backtotop" href="#top"><i class="fa fa-chevron-up"></i></a>
<!-- JAVASCRIPTS -->
<script src="../layout/scripts/jquery.min.js"></script>
<script src="../layout/scripts/jquery.backtotop.js"></script>
<script src="../layout/scripts/jquery.mobilemenu.js"></script>
<script src="https://cdn.jsdelivr.net/npm/cookieconsent@3/build/cookieconsent.min.js" data-cfasync="false"></script>
<script>
window.cookieconsent.initialise({
  "palette": {
    "popup": {
      "background": "#474747"
    },
    "button": {
      "background": "#9d0552"
    }
  },
  "content": {
    "message": "This website uses cookies to improve your experience. We'll assume you're ok with this, but you can opt-out if you wish.",
    "dismiss": "Accept Cookies"
  }
});
</script>

</body>
</html>