<!DOCTYPE html>

<html lang="en">
<!-- To declare your language - read more here: https://www.w3.org/International/questions/qa-html-language-declarations -->
<head>
<title>Mark Rothko | Art Experts</title>
<meta name="description" content="Mark Rothko art authentication, Mark Rothko appraisal, Full painting authentications. Certificate of authenticity (COA). we will sell your Mark Rothko.">
<meta name=”robots” content="index, follow">





















<link href="../layout/styles/test-layout.css" rel="stylesheet" type="text/css" media="all">
<link rel="stylesheet" type="text/css" href="https://cdn.jsdelivr.net/npm/cookieconsent@3/build/cookieconsent.min.css" />
<!-- Global site tag (gtag.js) - Google Analytics -->
<script async src="https://www.googletagmanager.com/gtag/js?id=G-NZ7GKNVDYS"></script>
<script>
  window.dataLayer = window.dataLayer || [];
  function gtag(){dataLayer.push(arguments);}
  gtag('js', new Date());

  gtag('config', 'G-NZ7GKNVDYS');
</script>
<link rel="canonical" href="<?php echo 'https://' . $_SERVER['HTTP_HOST'] . $_SERVER['REQUEST_URI']; ?>"><meta name="viewport" content="width=device-width, initial-scale=1.0"></head>

<?php include($_SERVER['DOCUMENT_ROOT']."/includes/header2.php");  ?>
<!-- ################################################################################################ -->
<!-- ################################################################################################ -->
<!-- ################################################################################################ -->
<div class="wrapper bgded overlay" style="display:none;background-image:url(../images/demo/backgrounds/09.png);">
  <div id="breadcrumb" class="hoc clear"> 
    <!-- ################################################################################################ -->
    <!-- ################################################################################################ -->
  </div>
</div>
<!-- ################################################################################################ -->
<!-- ################################################################################################ -->
<!-- ################################################################################################ -->
<div class="wrapper row3">
  <main class="hoc container clear"> 
    <!-- main body -->
    <!-- ################################################################################################ -->
    <div class="content three_quarter first" id="three_connn"> 
      <!-- ################################################################################################ -->

      
      
      <div>
        <h1 class="wow fadeInLeft" data-wow-delay=".4s">Mark Rothko (1903-1970)</h1>
      </div>
      <p class="wow fadeInLeft" data-wow-delay=".4s" align="justify">Mark Rothko art authentication. <a href="https://www.artexpertswebsite.com/appraisal/painting-appraisal.php">Mark Rothko appraisal</a>. <a href="https://www.artexpertswebsite.com/authentication/certificate-of-authenticity.php">Mark Rothko certificates of authenticity (COA)</a>.  Mark Rothko analysis, <a href="https://www.artexpertswebsite.com/authentication/provenance-research.php">research</a>, <a href="https://www.artexpertswebsite.com/authentication/scientific-tests.php">scientific tests</a>, <a href="https://www.artexpertswebsite.com/authentication.php">full art authentications</a>. We will help you sell your Mark Rothko or we will sell it for you. Please <a href="https://www.artexpertswebsite.com/contact/contact1.php">contact</a> us for more information.</p>
      <p  class="wow fadeInRight" data-wow-delay=".4s"><img src="uploads/artists/artists_l-z/rothko/Rothko_SelfPortrait.jpg" alt="art" width="auto" height="auto"></p>
      <div class="boldcap wow fadeInRight" data-wow-delay=".4s">Self-Portrait 1936</div>
      <p class="wow fadeInLeft" data-wow-delay=".4s" align="justify">Mark Rothko born Marcus Rothkowitz, was a Latvian-born American painter and printmaker who is classified as an abstract expressionist, although he rejected not only the label but even being an abstract painter. Rothko was born in Dvinsk, Latvia (Vitebsk guberniya, then part of the Russian Empire). His father Jacob was a pharmacist and an intellectual, who provided his children with a secular and political, rather than religious upbringing. However, following the Russian pogrom against Jews, incited by the 1905 revolution, Jacob repented and became a Baal teshuva. Unlike Jews in most cities of Czarist Russia, those in Dvinsk were spared a violent outbreak of reprisal. In an environment where Jews were often blamed for many of the evils that befell Russia, Rothko’s early childhood was plagued with fear, as he witnessed the occasional violence brought down upon Jews by Cossacks attempting to stifle revolutionary uprisings. An image that remained with him throughout his adult life was that of dug-up pits, where Cossacks were alleged to have buried Jews they kidnapped and murdered. Some critics interpret Rothko’s later use of rectangular forms as a formal representation of these graves. However, Rothko’s memory may be disputed, as no mass executions were said to have been committed in or near Dvinsk during this period.</p>
      <p  class="wow fadeInRight" data-wow-delay=".4s"><img src="uploads/artists/artists_l-z/rothko/Rothko_UntitledThreeNudes1926.jpg" alt="art" width="auto"></p>
      <div class="boldcap wow fadeInRight" data-wow-delay=".4s">Untitled, Nude 1926</div>
      <p class="wow fadeInLeft" data-wow-delay=".4s" align="justify">The Rothkowitzes were highly educated, despite Jacob’s modest income, and able to speak Russian, Yiddish and Hebrew. Following Jacob’s conversion to Orthodox Judaism, he sent Marcus, his youngest son, to the cheder at age five, where Rothko studied the Talmud. This had the adverse effect of stigmatizing him as an outsider within his own family, as his elders were educated in the public school system. As a Jew, the young Marcus was therefore an outsider among outsiders.</p>
      <p  class="wow fadeInRight" data-wow-delay=".4s"><img src="uploads/artists/artists_l-z/rothko/Rothko_EdgeOfTheSea.jpg" alt="art" width="auto"></p>
      <div class="boldcap wow fadeInRight" data-wow-delay=".4s">Edge of the Sea</div>
      <p class="wow fadeInLeft" data-wow-delay=".4s" align="justify">Fearing that his sons were about to be drafted into the Czarist army, Jacob decided to emigrate to the United States, following the path of many other Jews who left Dvinsk in the wake of the Cossack purges, including two of his brothers who managed to establish themselves as clothing manufacturers in Portland, Oregon, not an uncommon profession among Eastern European immigrants. Marcus remained in Russia with his mother and elder sister Sonia; they joined Jacob and the elder brothers later, arriving at Ellis Island in the winter of 1913, following a 12-day journey at sea. Shortly after their arrival, on March 27, 1914, Jacob died, leaving his family without economic support. One of Marcus’ great aunts worked as an unskilled laborer and Sonia worked a cash register, while Marcus found employment in one of his uncle’s warehouses, selling newspapers to employees. Later, Marcus’ mother took in boarders and Sonia worked as a dental assistant, while the other brothers opened a pharmacy, following in their father’s footsteps.</p>
      <p  class="wow fadeInRight" data-wow-delay=".4s"><img src="uploads/artists/artists_l-z/rothko/Rothko_UntitledSeatedWomanWithCrossedLegs1935.jpg" alt="art" width="auto" height="auto"></p>
      <div class="boldcap wow fadeInRight" data-wow-delay=".4s">Untitled, Seated Woman with Crossed Legs 1935</div>
      <p class="wow fadeInLeft" data-wow-delay=".4s" align="justify">Marcus started school in America in 1913, quickly accelerating from third to fifth grade, completing the remaining four grades in three years, then graduating to the secondary level which he completed, with honors, at Lincoln High School in Portland, in June of 1921 at the age of seventeen. He picked up his fourth language, English, and became an active member of the Jewish community center, where he proved adept at political discussions. Like his father, Marcus was liberal and passionate about such issues as worker’s rights and women’s right to contraception. Typical among Jewish liberals, Rothko supported the Russian Revolution yet his political conviction may be described as decorative in the sense that he was never politically engaged. Though he would later protest Nelson Rockefeller’s decision to remove by force Diego Rivera’s mural in the main building of Rockefeller Center, Rothko’s political convictions were typical of his culture and upbringing and mostly rhetoric.</p>
      <p  class="wow fadeInRight" data-wow-delay=".4s"><img src="uploads/artists/artists_l-z/rothko/Rothko_UndergroundFantasy1940.jpg" alt="art" width="auto"></p>
      <div class="boldcap wow fadeInRight" data-wow-delay=".4s">Underground Fantasy 1940</div>
      <p class="wow fadeInLeft" data-wow-delay=".4s" align="justify">Following graduation, he received a scholarship to Yale. The scholarship was based on academic performance, but it has been suggested that Yale only made the scholarship offer in order to lure Marcus’ friend, economist Aaron Director. After one year, the scholarship ran out and Marcus was forced to take menial jobs to support his studies. Marcus found the Waspish Yale community too elitist and racist for his taste; Marcus and Aaron Director started a satirical magazine, The Yale Saturday Evening Pest, which lampooned the school’s stuffy, bourgeois attitude. Following his second year, he dropped out, returning only after 46 years to receive an honorary degree.</p>
      <p  class="wow fadeInRight" data-wow-delay=".4s"><img src="uploads/artists/artists_l-z/rothko/Rothko_No9%201954.jpg" alt="art" width="auto" height="auto"></p>
      <div class="boldcap wow fadeInRight" data-wow-delay=".4s">No. 9, 1954</div>
      <p class="wow fadeInLeft" data-wow-delay=".4s" align="justify">In the fall of 1923, found employment in the garment district and took up residence on the Upper West Side. It was while visiting a friend at the Art Students League of New York that he witnessed students sketching a nude model. According to Rothko, this was the beginning of his life as an artist. He was twenty years old and had taken some art classes in high school but his initial experience was far from an immediate calling. Even his self-described “beginning” at the Art Students League of New York is not exactly true, for, two months after he returned to Portland to visit his family, he joined a theater group run by Clark Gable’s wife, Josephine Dillon. Whatever his promise as an actor, at 5’10” and a sturdy weight, Clark Gable he was not.</p>
      <p  class="wow fadeInRight" data-wow-delay=".4s"><img src="uploads/artists/artists_l-z/rothko/Rothko_RitesOfLilith1945.jpg" alt="art" width="auto"></p>
      <div class="boldcap wow fadeInRight" data-wow-delay=".4s">Rites of Lilith 1945</div>
      <p class="wow fadeInLeft" data-wow-delay=".4s" align="justify">Returning to New York, Rothko enrolled in the New School of Design, where one of his instructors was the artist Arshile Gorky, probably his first encounter with a member of the avant-garde. That Autumn, he took courses at the Art Students League of New York taught by still-life artist Max Weber, another Russian Jew. It was from Weber that Rothko began to see art as a tool of emotional and religious expression and Rothko’s earliest paintings portray a Weberian influence.</p>
      <p  class="wow fadeInRight" data-wow-delay=".4s"><img src="uploads/artists/artists_l-z/rothko/Rothko_Untitled1945-1946.jpg" alt="art" width="auto" height="auto"></p>
      <div class="boldcap wow fadeInRight" data-wow-delay=".4s">Untitled 1945-1946</div>
      <p class="wow fadeInLeft" data-wow-delay=".4s" align="justify">Rothko’s move to New York provided a fertile atmosphere for the experience of art from all cultures and periods. Modernist painters showed in the New York Galleries, and the city’s museums were an invaluable resource for the foster of a budding artist’s knowledge, experience and skills. Among those early influences were the works of the German Expressionists, the surrealist work of Paul Klee and the paintings of Georges Rouault. In 1928, Rothko had his own showing with a group of young artists at the appropriately named Opportunity Gallery. His paintings covered dark, moody, expressionist interiors as well as urban scenes and were generally well-accepted among critics and peers. Despite some growing success, Rothko still needed to supplement his income, and in 1929, he began giving classes in painting and clay sculpture at the Center Academy where he remained as teacher until 1952. During this time, he met Adolph Gottlieb, who, along with Barnett Newman, Joseph Sloman and John Graham, was part of a group of young artists surrounding the painter Milton Avery, 15 years Rothko’s senior. Avery’s stylized natural scenes, utilizing a rich knowledge of form and color, would be a tremendous influence on Rothko, whose own paintings soon after meeting Avery, began to address similar subject matter and color, as in Rothko’s 1933/34 Bathers, or Beach Scene.</p>
      <p  class="wow fadeInRight" data-wow-delay=".4s"><img src="uploads/artists/artists_l-z/rothko/Rothko_RedOnMaroon.jpg" alt="art" width="auto" height="auto"></p>
      <div class="boldcap wow fadeInRight" data-wow-delay=".4s">Red on Maroon</div>
      <p class="wow fadeInLeft" data-wow-delay=".4s" align="justify">Rothko, Gottlieb, Newman, Sloman, Graham and their mentor Avery, spent considerable time together, vacationing at Lake George and Gloucester, Massachusetts, spending their days painting and their evenings discussing art. Avery was very generous with his attention to these young artists, hosting literary readings and giving courses to them on nude drawings. During a 1932 visit to Lake George, Rothko met Edith Sachar, a jewelry designer. The two were married on November 12th and maintained, at first, a close and mutually supportive relationship. The following summer, Rothko’s first one-man show was held at the Portland Art Museum, consisting mostly of drawings and aquarelles, as well as the works of Rothko’s pre-adolescent students from the Center Academy. His family was unable to understand his decision to be an artist, especially at a time when the Depression was at its all time worst. Having suffered serious financial setbacks, the Rothkoviches were mystified by Rothko’s seeming indifference to financial necessity. They felt he was doing his mother a disservice by not finding a more lucrative (and realistic) career.</p>
      <p class="wow fadeInLeft" data-wow-delay=".4s" align="justify">In 1936, Rothko began writing a book, never completed, about the similarities in the art of children and the work of modern painters. The work of modernists, influenced by primitive art, could be compared to that of children in that “child art,” according to Rothko, “transforms itself into primitivism, which is only the child producing a mimicry of himself.” In this same manuscript, he observed that “the fact that one usually begins with drawing is already academic. We start with color.” The modernist artist, like the child and the primitive whom he is influenced by, expresses an innate feeling for form that is, in the best and most universal work, expressed without mental interference; it is a physical and emotional, non-intellectual experience. Rothko was using fields of color in his aquarelles and city scenes and his subject matter and form was, by this time, decidedly non-intellectual, of formal concern, though the composition betrays a deep intellect. Rothko seemed to have reached an illumination concerning the progression of his later works; however it is to the next period we must turn our attention, before proceeding to the mature, rectangular fields of color and light that either culminated or self-destructed in the Rothko Chapel.</p>
      <p  class="wow fadeInRight" data-wow-delay=".4s"><img src="uploads/artists/artists_l-z/rothko/Rothko_MultiformComposition.jpg" alt="art" width="auto" height="auto"></p>
      <div class="boldcap wow fadeInRight" data-wow-delay=".4s">Multiform Composition</div>
      <p class="wow fadeInLeft" data-wow-delay=".4s" align="justify">This period, between the primitivist and playful urban scenes and aquarelles of the early period and the late, transcendent fields of color, is one of transition, incorporating elements from both his early and late periods. It is marked by a rich and often complex milieu provoked mostly by two important events in Rothko’s life: the onset of World War and his reading of Friedrich Nietzsche.</p>
      <p class="wow fadeInLeft" data-wow-delay=".4s" align="justify">Rothko separated from his wife, Edith Sachar, in the summer of 1937, following Edith’s increased success in the jewelry business. Apparently, he did not enjoy working for his wife and felt both threatened by and jealous of her financial success; Rothko was, by comparison, a financial failure. He and Edith reconciled in the Fall, yet their relationship remained tense. On the 21st of February, Rothko finally became a citizen of the United States, prompted by fears that the growing Nazi influence in Europe might provoke sudden deportation of American Jews. A similar rise of Nazi sympathy in the United States only increased these fears and in January of 1940, Marcus Rothkovich changed his name to Mark Rothko, as the name “Roth,” a common abbreviation, had become, as a result of its commonality, identifiably Jewish. Following the Hitler-Stalin Pact of 1939, Rothko, along with Avery, Gottlieb, and others, left the American Artists’ Congress in protest of the Congress’ association with radical communism. In June, he and a number of other artists formed the Federation of Modern Painters and Sculptors. Their agenda was to keep art free from political propaganda.</p>
      <p  class="wow fadeInRight" data-wow-delay=".4s"><img src="uploads/artists/artists_l-z/rothko/Rothko_UntitledStudy.jpg" alt="art" width="auto" height="auto"></p>
      <div class="boldcap wow fadeInRight" data-wow-delay=".4s">Untitled Study</div>
      <p class="wow fadeInLeft" data-wow-delay=".4s" align="justify">On June 13, 1943, Rothko and Edith separated again. Rothko suffered a long depression following their divorce. Thinking a change of scenery might help, Rothko returned to Portland and later traveled to Berkeley, where he met artist Clyfford Still, with whom he began a close friendship. Still’s deeply abstract paintings would be of considerable influence on Rothko’s later works. In the fall, Rothko returned to New York where he met the collector Peggy Guggenheim and her assistant, Howard Putzel, who convinced Guggenheim to show Rothko in her Art of the Century gallery. In 1944, photographer Aaron Siskind introduced Rothko to Mary Alice Beistle, a 23-year old illustrator of children’s books, and the two fell in love and were married in the spring of 1945. The marriage was considerably happier than his first. Rothko’s one-man show at the Guggenheim in late 1945 resulted in few sales (priced between $150 and $750) and less-than-favorable reviews. Sensing that his art was becoming passé and no longer a viable medium for the direction he was moving (stimulated by Still’s abstract landscapes of color), Rothko broke with the Surrealists, explaining:</p>
      <p  class="wow fadeInRight" data-wow-delay=".4s"><img src="uploads/artists/artists_l-z/rothko/Rothko_No%202.jpg" alt="art" width="auto" height="auto"></p>
      <div class="boldcap wow fadeInRight" data-wow-delay=".4s">No. 2 1951</div>
      <p class="wow fadeInLeft" data-wow-delay=".4s" align="justify">“I insist upon the equal existence of the world engendered in the mind and the world engendered by God outside of it. If I have faltered in the use of familiar objects, it is because I refuse to mutilate their appearance for the sake of an action which they are too old to serve, or for which perhaps they had never been intended. I quarrel with surrealists and abstract art only as one quarrels with his father and mother; recognizing the inevitability and function of my roots, but insistent upon my dissent; I, being both they, and an integral completely independent of them.”</p>
      <p  class="wow fadeInRight" data-wow-delay=".4s"><img src="uploads/artists/artists_l-z/rothko/Rothko_Untitled1948.jpg" alt="art" width="auto" height="auto"></p>
      <div class="boldcap wow fadeInRight" data-wow-delay=".4s">Untitled 1948</div>
      <p class="wow fadeInLeft" data-wow-delay=".4s" align="justify">Rothko could no longer bring himself to continue interpreting the unconscious symbolism of everyday forms. The experiment had run its course. His future lay with abstraction; in it, Rothko found release from the Surrealist program of the humanist impulse to mere “memory and hallucination.” Despite the abandonment of his project as a “Mythomorphic Abstractionist” (as described by Art News), Rothko became primarily identified with his Surrealist works for the remainder of the 1940’s. The Whitney Museum included them in their annual exhibit of Contemporary Art from 1943 to 1950. The “Abstract Expressionist” movement was a loose consortium of mostly secular, urban Jews including Rothko and two other artists he was associated with, Gottlieb and Newman. Self-perceived outsiders and intellectuals, they viewed the freedom afforded by Modernism with no small degree of suspicion, interpreting this freedom as a source of suffering as opposed to release.</p>
      <p class="wow fadeInLeft" data-wow-delay=".4s" align="justify">His 1945 masterpiece Slow Swirl at Edge of Sea magnificently illustrates Rothko’s newfound propensity towards abstraction. Interpreted by many critics as a meditation on Rothko’s courtship of his second wife Mell, the painting presents two humanlike forms embraced in a swirling, floating atmosphere of shapes and colors, subtle grays and browns. The rigid rectangular background foreshadows Rothko’s later experiments in pure color. The painting was completed, not coincidentally, the year the Second World War ended.</p>
      <p  class="wow fadeInRight" data-wow-delay=".4s"><img src="uploads/artists/artists_l-z/rothko/Rothko_3,1949.gif" alt="art"></p>
      <div class="boldcap wow fadeInRight" data-wow-delay=".4s">No. 3 1949</div>
      <p class="wow fadeInLeft" data-wow-delay=".4s" align="justify">1946 saw the creation of Rothko’s new “multiform” paintings. In viewing the catalogue raisonne, one finds a gradual metamorphosis from surrealistic, myth-influenced paintings of the early part of the decade to those highly abstract, Clyfford Still-influenced forms of pure color. The term “multiform” is applied by art critics; it was never utilized by Rothko himself, yet it is an accurate description of these paintings, which, as with his paintings of the latter part of the previous decade, are best viewed as a period of transition from that of surrealism to abstraction. Several of them, including No. 18 (1948) and Untitled (also 1948), are masterpieces in their own right. Rothko himself described these paintings as possessing a more organic structure, as self-contained units of human expression. For Rothko, these blurred blocks of various colors, devoid of landscape or human figure, let alone myth and symbol, possessed their own life force. They contained a “breath of life” he found lacking in most figurative painting of the era. This new form seemed filled with possibility, whereas his experimentation with mythological symbolism was, at best, a tired formula, much as he viewed his late 1930’s experiments in urban settings. The “multiforms” brought Rothko to a realization of his mature, signature style, the only style Rothko did not fully abandon, perhaps only because he died before he had the chance.</p>
      <p class="wow fadeInLeft" data-wow-delay=".4s" align="justify">Earlier that year Rothko spent some time in California following a brief resurgence of interest among Californians in his Surrealist paintings. He found work teaching at the California School of Fine Art and while there encountered the work of Clyfford Still. Rothko, in the middle of a crucial period of transition, was impressed by Still’s abstract fields of color, influenced in part by the landscapes of Still’s native North Dakota. In 1947, during a subsequent semester teaching at the School of Fine Art, Rothko and Still flirted with the idea of founding their own curriculum; they would realize this idea the following year in New York. Named “The Subjects of the Artists School,” they employed David Hare and Robert Motherwell, among others. Though it would fold the same year, the school was the center of a flurry of activity in contemporary art. In addition to his experience teaching, Rothko began contributing articles to two new art publications, Tiger’s Eye and Possibilities. Using the forum as an opportunity to assess the current art scene, Rothko also discussed in detail his own artwork and philosophy of art . These articles reveal an artist in transition, seeking to eliminate figurative elements from his work. He described his new method as “unknown adventures in an unknown space,” free from “direct association with any particular, and the passion of organism.”</p>
      <p  class="wow fadeInRight" data-wow-delay=".4s"><img src="uploads/artists/artists_l-z/rothko/Rothko_Untitled1949.jpg" alt="art" width="auto" height="auto"></p>
      <div class="boldcap wow fadeInRight" data-wow-delay=".4s">Untitled 1949</div>
      <p class="wow fadeInLeft" data-wow-delay=".4s" align="justify">In the spring of 1968, Rothko suffered an aneurysm of the aorta, a result of his chronic high blood pressure. Ignoring doctor’s orders, Rothko continued to drink and smoke heavily, avoid exercise and maintain an unhealthy diet. However, he followed the advice not to paint pictures larger than a yard in height and turned his attention to smaller formats, including acrylics on paper. Due to impotence, Rothko and his wife Mell separated on New Year’s Day 1969, and he moved into his studio. Sensing the end was near, Rothko and his financial advisor, Bernard Reis, created a foundation intended to fund “research and education” that would receive the bulk of Rothko’s work following his death. (Reis later sold the paintings to the Marlborough Gallery at a considerable loss and pocketed the difference with Gallery representatives, the result of which was one of the longest and most heavily hyped legal battles in art history.)</p>
      <p class="wow fadeInLeft" data-wow-delay=".4s" align="justify">On February 25, 1970, Oliver Steindecker, Rothko’s assistant, found the artist in his kitchen, lying dead on the floor in front of the sink, covered in blood. His arms had been sliced open with a razor lying at his side. During autopsy it was discovered he had also overdosed on anti-depressants. He was 66 years old.</p>
      <p  class="wow fadeInRight" data-wow-delay=".4s"><img src="uploads/artists/artists_l-z/rothko/Rothko_No.61%201953.jpg" alt="art" width="auto" height="auto"></p>
      <div class="boldcap wow fadeInRight" data-wow-delay=".4s">No. 61, 1953</div>
      <p class="wow fadeInLeft" data-wow-delay=".4s" align="justify">Today, Mark Rothko remains one of the most famous painters of the 20th century, and his works are housed in museums and private collections world wide. Still wondering about a painting in your family collection? <a href="https://www.artexpertswebsite.com/contact/contact1.php">Contact us</a>…it could be by Mark Rothko.</p>
      
      <!-- ################################################################################################ -->
    </div>
    <!-- ################################################################################################ -->
    <!-- ################################################################################################ -->
    <?php include($_SERVER['DOCUMENT_ROOT']."/includes/right-sidebar.php");  ?>
    <!-- ################################################################################################ -->
    <!-- / main body -->

  </main>
</div>
<!-- ################################################################################################ -->
<!-- ################################################################################################ -->
<!-- ################################################################################################ -->
<?php include($_SERVER['DOCUMENT_ROOT']."/includes/footer.php");  ?>
<!-- ################################################################################################ -->
<!-- ################################################################################################ -->
<!-- ################################################################################################ -->
<?php include($_SERVER['DOCUMENT_ROOT']."/includes/copyright.php");  ?><!-- ################################################################################################ -->
<!-- ################################################################################################ -->
<!-- ################################################################################################ -->
<a id="backtotop" href="#top"><i class="fa fa-chevron-up"></i></a>
<!-- JAVASCRIPTS -->
<script src="../layout/scripts/jquery.min.js"></script>
<script src="../layout/scripts/jquery.backtotop.js"></script>
<script src="../layout/scripts/jquery.mobilemenu.js"></script>
<script src="https://cdn.jsdelivr.net/npm/cookieconsent@3/build/cookieconsent.min.js" data-cfasync="false"></script>
<script>
window.cookieconsent.initialise({
  "palette": {
    "popup": {
      "background": "#474747"
    },
    "button": {
      "background": "#9d0552"
    }
  },
  "content": {
    "message": "This website uses cookies to improve your experience. We'll assume you're ok with this, but you can opt-out if you wish.",
    "dismiss": "Accept Cookies"
  }
});
</script>

</body>
</html>