<!DOCTYPE html>

<html lang="en">
<!-- To declare your language - read more here: https://www.w3.org/International/questions/qa-html-language-declarations -->
<head>
<title>Bertel Thorvaldsen | Art Experts</title>
<meta name="description" content="Bertel Thorvaldsen art authentication, Bertel Thorvaldsen appraisal, Full painting authentications. Certificate of authenticity (COA). we will sell your Bertel Thorvaldsen.">
<meta name=”robots” content="index, follow">






















<link href="../layout/styles/test-layout.css" rel="stylesheet" type="text/css" media="all">
<link rel="stylesheet" type="text/css" href="https://cdn.jsdelivr.net/npm/cookieconsent@3/build/cookieconsent.min.css" />
<!-- Global site tag (gtag.js) - Google Analytics -->
<script async src="https://www.googletagmanager.com/gtag/js?id=G-NZ7GKNVDYS"></script>
<script>
  window.dataLayer = window.dataLayer || [];
  function gtag(){dataLayer.push(arguments);}
  gtag('js', new Date());

  gtag('config', 'G-NZ7GKNVDYS');
</script>
<link rel="canonical" href="<?php echo 'https://' . $_SERVER['HTTP_HOST'] . $_SERVER['REQUEST_URI']; ?>"><meta name="viewport" content="width=device-width, initial-scale=1.0"></head>

<?php include($_SERVER['DOCUMENT_ROOT']."/includes/header2.php");  ?>



<div class="wrapper bgded overlay" style="display:none;background-image:url(../images/demo/backgrounds/09.png);">
  <div id="breadcrumb" class="hoc clear"> 
    
    
  </div>
</div>



<div class="wrapper row3">
  <main class="hoc container clear"> 
    <!-- main body -->
    
    <div class="content three_quarter first" id="three_connn"> 
      

      
      
      <div>
        <h1 class="wow fadeInLeft" data-wow-delay=".4s">Bertel Thorvaldsen (1770-1844)</h1>
      </div>
      <p class="wow fadeInLeft" data-wow-delay=".4s">We Perform Bertel Thorvaldsen art authentication. <a href="https://www.artexpertswebsite.com/appraisal/painting-appraisal.php">Bertel Thorvaldsen appraisal</a>. <a href="https://www.artexpertswebsite.com/authentication/certificate-of-authenticity.php">Bertel Thorvaldsen certificates of authenticity (COA)</a>.  Bertel Thorvaldsen analysis, <a href="https://www.artexpertswebsite.com/authentication/provenance-research.php">research</a>, <a href="https://www.artexpertswebsite.com/authentication/scientific-tests.php">scientific tests</a>, <a href="https://www.artexpertswebsite.com/authentication.php">full art authentications</a>. We will help you sell your Bertel Thorvaldsen or we will sell it for you.</p>
      <p class="wow fadeInLeft" data-wow-delay=".4s">Thorvaldsen was born in Copenhagen in 1770 (according to some accounts, in 1768), the son of an Icelander who had settled in Denmark and there carried on the trade of a wood-carver. This account is disputed by some Icelanders, who claim Thorvaldsen was born in Iceland.</p>
      <p  class="wow fadeInRight" data-wow-delay=".4s"><img src="uploads/artists/artists_l-z/thorvaldsen/alexander1.jpg" alt="Bust of Alexander I" width="auto" height="auto"></p>
      <div class="boldcap wow fadeInRight" data-wow-delay=".4s">Bust of Alexander I</div>
      <p class="wow fadeInLeft" data-wow-delay=".4s">Young Thorvaldsen attended Copenhagen’s Royal Danish Academy of Art (Det Kongelige Danske Kunstakademi), winning all the prizes including the large Gold Medal. As a consequence, he was granted a Royal stipend, enabling him to complete his studies in Rome, where he arrived on March 8, 1797. Since the date of his birth had never been recorded, he celebrated this day as his “Roman birthday” for the rest of his life.</p>
      <p  class="wow fadeInRight" data-wow-delay=".4s"><img src="uploads/artists/artists_l-z/thorvaldsen/cupidandpsyche.jpg" alt="Cupid and Psyche" width="auto" height="auto"></p>
      <div class="boldcap wow fadeInRight" data-wow-delay=".4s">Cupid and Psyche</div>
      <p class="wow fadeInLeft" data-wow-delay=".4s">Thorvaldsen’s first success was the model for a statue of Jason, which was highly praised by Antonio Canova, the most popular sculptor in the city. In 1803 he received the commission to execute it in marble from Thomas Hope, a wealthy English art-patron. From that time Thorvaldsen’s success was assured, and he did not leave Italy for sixteen years.</p>
      <p  class="wow fadeInRight" data-wow-delay=".4s"><img src="uploads/artists/artists_l-z/thorvaldsen/jason.jpg" alt="Jason" width="auto"></p>
      <div class="boldcap wow fadeInRight" data-wow-delay=".4s">Jason</div>
      <p class="wow fadeInLeft" data-wow-delay=".4s">In 1819 he visited his native Denmark. Here he was commissioned to make the colossal series of statues of Christ and the twelve Apostles for the rebuilding of Vor Frue Kirke (from 1922 known as the Copenhagen Cathedral) between 1817 and 1829, after its having been destroyed in the British bombardment of Copenhagen in 1807. These were executed after his return to Rome, and were not completed till 1838, when Thorvaldsen returned to Denmark, being received as a hero.</p>
      <p  class="wow fadeInRight" data-wow-delay=".4s"><img src="uploads/artists/artists_l-z/thorvaldsen/thorvaldsen-venus1.jpg" alt="Venus" width="auto" height="auto"></p>
      <div class="boldcap wow fadeInRight" data-wow-delay=".4s">Venus</div>
      <p class="wow fadeInLeft" data-wow-delay=".4s">He died suddenly in the Copenhagen Royal Theatre on March 24, 1844, and bequeathed a great part of his fortune for the building and endowment of a museum in Copenhagen, and also left to fill it all his collection of works of art and the models for all his sculptures very large collection, exhibited to the greatest possible advantage. Thorvaldsen is buried in the courtyard of this museum, under a bed of roses, by his own special wish.</p>
      <p class="wow fadeInLeft" data-wow-delay=".4s">Thorvaldsen never married, but he had an illegitimate daughter with a long-time love. Thorvaldsen did acknowledge this daughter, and to this day, descendants of Thorvaldsen live in the United States and Sicily.</p>
      <p class="wow fadeInLeft" data-wow-delay=".4s">Thorvaldsen was an outstanding representative of the Neoclassical period in sculpture. He was often compared to Antonio Canova, but in fact he embodied the style of classical Greek art more than the Italian artist. The poses and expressions of his figures are much more stiff and formal than those of Canova’s.</p>
      <p  class="wow fadeInRight" data-wow-delay=".4s"><img src="uploads/artists/artists_l-z/thorvaldsen/threegracesandcupid.jpg" alt="The Three Graces and Cupid 1819" width="auto" height="auto"></p>
      <div class="boldcap wow fadeInRight" data-wow-delay=".4s">The Three Graces and Cupid 1819</div>
      <p class="wow fadeInLeft" data-wow-delay=".4s">Motifs for his works (reliefs, statues, and busts) were drawn mostly from Greek mythology, but he also created portraits of important personalities, as in his statue of Pope Pius VII. His works can be seen in many European countries, especially in the Thorvaldsen Museum in Copenhagen, where his tomb is in the inner courtyard. Thorvaldsen’s Lion Monument (1819) is in Lucerne, Switzerland. This monument commemorates the sacrifice of more than six hundred Swiss Guards who died defending the Tuileries during the French Revolution. The monument portrays a dying lion lying across broken symbols of the French monarchy.</p>
      <p  class="wow fadeInRight" data-wow-delay=".4s"><img src="uploads/artists/artists_l-z/thorvaldsen/lionmonumentlucern.jpg" alt="Lion Monument Lucerne" width="auto" height="auto"></p>
      <div class="boldcap wow fadeInRight" data-wow-delay=".4s">Lion Monument Lucerne</div>
      <p class="wow fadeInLeft" data-wow-delay=".4s">Thorvaldsen produced some striking and affecting statues of historic figures, including two in Warsaw, Poland: the seated Nicolaus Copernicus, before the Polish Academy of Sciences building, and the equestrian statue of Prince Józef Poniatowski that now stands before the Presidential Palace, both located on Warsaw’s Krakowskie Przedmiescie. Mainz, Germany, has Thorvaldsen’s statue of Johannes Gutenberg.</p>
      <p class="wow fadeInLeft" data-wow-delay=".4s">Part of Gutenberg’s work is informed by a pronounced classicist sensibility, traditionally encoded in European art in the myth of Zeus and Ganymede. Illustrative are his Eros, several versions of Ganymede, the Shepherd Boy with Dog, and his bas relief of Hylas and the Nymphs, depicting a shapely Hylas terrified of the nubile nymphs embracing him.</p>
      <p class="wow fadeInLeft" data-wow-delay=".4s">Outside Europe, Thorvaldsen is less well known. Additionally, his statue of the resurrected Christ, commonly referred to as Thorvaldsen’s Christus (created for what is now the Lutheran Cathedral in Copenhagen,) has appealed to the members of The Church of Jesus Christ of Latter-day Saints and a 3.4 m replica is on display at Temple Square and images of the statue are used in official church media, such as the internet site LDS.org.</p>
      <p  class="wow fadeInRight" data-wow-delay=".4s"><img src="uploads/artists/artists_l-z/thorvaldsen/christstatue.jpg" alt="Christ Statue" width="auto"></p>
      <div class="boldcap wow fadeInRight" data-wow-delay=".4s">Christ Statue</div>
      <p class="wow fadeInLeft" data-wow-delay=".4s">A bronze copy of Thorvaldsen’s Self-Portrait stands in Central Park, New York, near the East 97 Street entrance.</p>
      <p class="wow fadeInLeft" data-wow-delay=".4s">Still wondering about an 18th or 19th century sculpture in your family collection? <a href="https://www.artexpertswebsite.com/contact/contact1.php">Contact us</a>…it could be by Bertel Thorvaldsen.</p>
      
      
    </div>
    
    
    <?php include($_SERVER['DOCUMENT_ROOT']."/includes/right-sidebar.php");  ?>
    
    <!-- / main body -->

  </main>
</div>



<?php include($_SERVER['DOCUMENT_ROOT']."/includes/footer.php");  ?>



<?php include($_SERVER['DOCUMENT_ROOT']."/includes/copyright.php");  ?>


<a id="backtotop" href="#top"><i class="fa fa-chevron-up"></i></a>
<!-- JAVASCRIPTS -->
<script src="../layout/scripts/jquery.min.js"></script>
<script src="../layout/scripts/jquery.backtotop.js"></script>
<script src="../layout/scripts/jquery.mobilemenu.js"></script>
<script src="https://cdn.jsdelivr.net/npm/cookieconsent@3/build/cookieconsent.min.js" data-cfasync="false"></script>
<script>
window.cookieconsent.initialise({
  "palette": {
    "popup": {
      "background": "#474747"
    },
    "button": {
      "background": "#9d0552"
    }
  },
  "content": {
    "message": "This website uses cookies to improve your experience. We'll assume you're ok with this, but you can opt-out if you wish.",
    "dismiss": "Accept Cookies"
  }
});
</script>

</body>
</html>