<!DOCTYPE html>

<html lang="en">
<!-- To declare your language - read more here: https://www.w3.org/International/questions/qa-html-language-declarations -->
<head>
<title>Tintoretto | Art Experts</title>
<meta name="description" content="Tintoretto art authentication, Tintoretto appraisal, Full painting authentications. Certificate of authenticity (COA). we will sell your Tintoretto.">
<meta name=”robots” content="index, follow">






















<link href="../layout/styles/test-layout.css" rel="stylesheet" type="text/css" media="all">
<link rel="stylesheet" type="text/css" href="https://cdn.jsdelivr.net/npm/cookieconsent@3/build/cookieconsent.min.css" />
<!-- Global site tag (gtag.js) - Google Analytics -->
<script async src="https://www.googletagmanager.com/gtag/js?id=G-NZ7GKNVDYS"></script>
<script>
  window.dataLayer = window.dataLayer || [];
  function gtag(){dataLayer.push(arguments);}
  gtag('js', new Date());

  gtag('config', 'G-NZ7GKNVDYS');
</script>
<link rel="canonical" href="<?php echo 'https://' . $_SERVER['HTTP_HOST'] . $_SERVER['REQUEST_URI']; ?>"><meta name="viewport" content="width=device-width, initial-scale=1.0"></head>

<?php include($_SERVER['DOCUMENT_ROOT']."/includes/header2.php");  ?>



<div class="wrapper bgded overlay" style="display:none;background-image:url(../images/demo/backgrounds/09.png);">
  <div id="breadcrumb" class="hoc clear"> 
    
    
  </div>
</div>



<div class="wrapper row3">
  <main class="hoc container clear"> 
    <!-- main body -->
    
    <div class="content three_quarter first" id="three_connn"> 
      

      
      
      <div>
        <h1 class="wow fadeInLeft" data-wow-delay=".4s">Tintoretto (1518-1594)</h1>
      </div>
      <p class="wow fadeInLeft" data-wow-delay=".4s" align="justify">Tintoretto art authentication. <a href="https://www.artexpertswebsite.com/appraisal/painting-appraisal.php">Tintoretto appraisal</a>. <a href="https://www.artexpertswebsite.com/authentication/certificate-of-authenticity.php">Tintoretto certificates of authenticity (COA)</a>.  Tintoretto analysis, <a href="https://www.artexpertswebsite.com/authentication/provenance-research.php">research</a>, <a href="https://www.artexpertswebsite.com/authentication/scientific-tests.php">scientific tests</a>, <a href="https://www.artexpertswebsite.com/authentication.php">full art authentications</a>. We will help you sell your Tintoretto or we will sell it for you.</p>
      <p  class="wow fadeInRight" data-wow-delay=".4s"><img src="uploads/artists/artists_l-z/tintoretto/Tintoretto_SelfPortrait.jpg" alt="art" width="auto" height="auto"></p>
      <div class="boldcap wow fadeInRight" data-wow-delay=".4s">Self-Portrait</div>
      <p class="wow fadeInLeft" data-wow-delay=".4s" align="justify">Tintoretto was born Jacopo Comin, and was one of the greatest painters of the Venetian school and probably the last great painter of the Italian Renaissance. In his youth he was also called Jacopo Robusti, as his father had defended the gates of Padua in a rather robust way against the imperial troops. His real name ‘Comin’ has only recently been discovered by Miguel Falomir, the curator of the Prado, Madrid and has been made public at the occasion of the retrospective of Tintoretto at the Prado, opening on 29 January 2007.</p>
      <p class="wow fadeInLeft" data-wow-delay=".4s" align="justify">For his phenomenal energy in painting he was termed Il Furioso, and his dramatic use of perspectival space and special lighting effects make him a precursor of baroque art.</p>
      <p  class="wow fadeInRight" data-wow-delay=".4s"><img src="uploads/artists/artists_l-z/tintoretto/Tintoretto_LedaAndTheSwan.jpg" alt="art" width="auto"></p>
      <div class="boldcap wow fadeInRight" data-wow-delay=".4s">Leda and the Swan 1555</div>
      <p class="wow fadeInLeft" data-wow-delay=".4s" align="justify">He was born in Venice, Republic of Venice in 1518, as the eldest of 21 children. His father, Giovanni, was a dyer, or tintore; hence the son got the nickname of Tintoretto, little dyer, or dyer’s boy, which is Anglicized as Tintoret. The family originated from Brescia, a city-state about 170 km from Venice. Older studies gave the Tuscan town of Lucca as the origin of the family.</p>
      <p class="wow fadeInLeft" data-wow-delay=".4s">In childhood Jacopo, a born painter, began daubing on the dyer’s walls; his father, noticing his bent, took him to the studio of Titian to see how far he could be trained as an artist. We may suppose this to have been towards 1533, when Titian was already (according to the ordinary accounts) fifty-six years of age.</p>
      <p class="wow fadeInLeft" data-wow-delay=".4s">Tintoretto had only been ten days in the studio when Titian sent him home once and for all, the reason being that the great master observed some very spirited drawings, which he learned to be the production of Tintoretto; and it is inferred that he became at once jealous of so promising a scholar¹. This, however, is mere conjecture; and perhaps it may be fairer to suppose that the drawings exhibited so much independence of manner that Titian judged that young Jacopo, although he might become a painter, would never be properly a pupil.</p>
      <p  class="wow fadeInRight" data-wow-delay=".4s"><img src="uploads/artists/artists_l-z/tintoretto/Tintoretto_MadonnaWithChildAndDonor.jpg" alt="art" width="auto"></p>
      <div class="boldcap wow fadeInRight" data-wow-delay=".4s">Madonna with Child and Donor</div>
      <p class="wow fadeInLeft" data-wow-delay=".4s" align="justify">From this time forward the two always remained upon distant terms, Tintoretto being indeed a professed and ardent admirer of Titian, but never a friend, and Titian and his adherents turning the cold shoulder to him. Active disparagement also was not wanting, but it passed unnoticed by Tintoretto. The latter sought for no further teaching, but studied on his own account with laborious zeal; he lived poorly, collecting casts, bas-reliefs, &amp;c., and practising by their aid. His noble conception of art and his high personal ambition were evidenced in the inscription which he placed over his studio Il disegno di Michelangelo ed il colorito di Tiziano (“Michelangelo’s design and Titian’s color”).</p>
      <p  class="wow fadeInRight" data-wow-delay=".4s"><img src="uploads/artists/artists_l-z/tintoretto/Tintoretto_TheOriginOfTheMilkyWay.jpg" alt="art" width="auto"></p>
      <div class="boldcap wow fadeInRight" data-wow-delay=".4s">The Origin of the Milky Way</div>
      <p class="wow fadeInLeft" data-wow-delay=".4s" align="justify">He studied more especially from models of Michelangelo’s Dawn, Noon, Twilight and Night, and became expert in modeling in wax and clay method (practiced likewise by Titian) which afterwards stood him in good stead in working out the arrangement of his pictures. The models were sometimes taken from dead subjects dissected or studied in anatomy schools; some were draped, others nude, and Tintoretto was to suspend them in a wooden or cardboard box, with an aperture for a candle. Now and afterwards he very frequently worked by night as well as by day.</p>
      <p  class="wow fadeInRight" data-wow-delay=".4s"><img src="uploads/artists/artists_l-z/tintoretto/Tintoretto_StGeorgeAndTehDragon.jpg" alt="art" width="auto"></p>
      <div class="boldcap wow fadeInRight" data-wow-delay=".4s">St. George and the Dragon 1555-1558</div>
      <p class="wow fadeInLeft" data-wow-delay=".4s" align="justify">The young painter Schiavone, four years Tintoretto’s junior, was much in his company. Tintoretto helped Schiavone gratis in wall-paintings; and in many subsequent instances he worked also for nothing, and thus succeeded in obtaining commissions. The two earliest mural paintings of Tintoretto – done, like others, for next to no pay – are said to have been Belshazzar’s Feast and a Cavalry Fight. These are both long since perished, as are all his frescoes, early or later. The first work of his to attract some considerable notice was a portrait-group of himself and his brother – the latter playing a guitar – with a nocturnal effect; this also is lost. It was followed by some historical subject, which Titian was candid enough to praise.</p>
      <p  class="wow fadeInRight" data-wow-delay=".4s"><img src="uploads/artists/artists_l-z/tintoretto/Tintoretto_TheMiracleOfTheSlave.jpg" alt="art" width="auto"></p>
      <div class="boldcap wow fadeInRight" data-wow-delay=".4s">Miracle of the Slave 1548</div>
      <p class="wow fadeInLeft" data-wow-delay=".4s" align="justify">One of Tintoretto’s early pictures still extant is in the church of the Carmine in Venice, the Presentation of Jesus in the Temple; also in S. Benedetto are the Annunciation and Christ with the Woman of Samaria. For the Scuola della Trinity (the scuole or schools of Venice were more in the nature of hospitals or charitable foundations than of educational institutions) he painted four subjects from Genesis. Two of these, now in the Venetian Academy, are Adam and Eve and the Death of Abel, both noble works of high mastery, which leave us in no doubt that Tintoretto was by this time a consummate painter – one of the few who have attained to the highest eminence in the absence of any formal training.</p>
      <p  class="wow fadeInRight" data-wow-delay=".4s"><img src="uploads/artists/artists_l-z/tintoretto/Tintoretto_ChristAtTheSeaOfGalilee.jpg" alt="art" width="auto"></p>
      <div class="boldcap wow fadeInRight" data-wow-delay=".4s">Christ at the Sea of Galilee 1575-1580</div>
      <p class="wow fadeInLeft" data-wow-delay=".4s" align="justify">Towards 1546 Tintoretto painted for the church of the Madonna dell Orto three of his leading works – the Worship of the Golden Calf, the Presentation of the Virgin in the Temple, and the Last Judgment now shamefully repainted; and he settled down in a house hard by the church. It is a Gothic edifice, looking over the lagoon of Murano to the Alps, built in the Fondamenta de Mori, still standing. In 1548 he was commissioned for four pictures in the Scuola di S. Marco – the Finding of the body of St Mark in Alexandria (now in the church of the Angeli, Murano), the Saint’s Body brought to Venice, a Votary of the Saint delivered by invoking him from an Unclean Spirit (these two are in the library of the royal palace, Venice), and the highly and justly celebrated Miracle of the Slave. This last, which forms at present one of the chief glories of the Venetian Academy, represents the legend of a Christian slave or captive who was to be tortured as a punishment for some acts of devotion to the evangelist, but was saved by the miraculous intervention of the latter, who shattered the bone-breaking and blinding implements which were about to be applied.</p>
      <p  class="wow fadeInRight" data-wow-delay=".4s"><img src="uploads/artists/artists_l-z/tintoretto/Tintoretto_FindingOfTheBodyofStMark.jpg" alt="art" width="auto"></p>
      <div class="boldcap wow fadeInRight" data-wow-delay=".4s">The Finding of the Body of St. Mark 1548</div>
      <p  class="wow fadeInRight" data-wow-delay=".4s"><img src="uploads/artists/artists_l-z/tintoretto/Tintoretto_StMarksBodyBroughtToVenice.jpg" alt="art" width="auto" height="auto"></p>
      <div class="boldcap wow fadeInRight" data-wow-delay=".4s">St. Mark’s Body Brought to Venice</div>
      <p class="wow fadeInLeft" data-wow-delay=".4s" align="justify">These four works were greeted with signal and general applause, including that of Titian’s intimate, the too potent Pietro Aretino, with whom Tintoretto, one of the few men who scorned to curry favor with him, was mostly in disrepute. It is said, however, that Tintoretto at one time painted a ceiling in Pietro’s house; at another time, being invited to do his portrait, he attended, and at once proceeded to take his sitter’s measure with a pistol (or a stiletto), as a significant hint that he was not exactly the man to be trifled with. The painter having now executed the four works in the Scuola di S. Marco, his straits and obscure endurances were over.</p>
      <p class="wow fadeInLeft" data-wow-delay=".4s" align="justify">In 1550 he married Faustina de Vescovi , daughter of a Venetian nobleman and a prominent member of the Scuola de San Marcos. She appears to have been a careful housewife, and one who both would and could have her way with her not too tractable husband. Faustina bore him several children, probably two sons and five daughters. The mother of Jacopo’s daughter Marietta was probably a German woman, who had an affair with Jacopo before his marriage to Faustina.</p>
      <p class="wow fadeInLeft" data-wow-delay=".4s" align="justify">The next conspicuous event in the professional life of Tintoretto is his enormous labor and profuse self-development on the walls and ceilings of the Scuola di S. Rocco, a building which may now almost be regarded as a shrine reared by Tintoretto to his own genius. The building had been begun in 1525 by the Lombardi, and was very deficient in light, so as to be particularly ill-suited for any great scheme of pictorial adornment. The painting of its interior was commenced in 1560.</p>
      <p  class="wow fadeInRight" data-wow-delay=".4s"><img src="uploads/artists/artists_l-z/tintoretto/Tintoretto_TheDeliveranceOfArsenoe.jpg" alt="art" width="auto"></p>
      <div class="boldcap wow fadeInRight" data-wow-delay=".4s">The Deliverance of Arsenoe 1560</div>
      <p class="wow fadeInLeft" data-wow-delay=".4s" align="justify">In that year five principal painters, including Tintoretto and Paolo Veronese, were invited to send in trial-designs for the centre-piece in the smaller hall named Sala dell’Albergo, the subject being S. Rocco received into Heaven. Tintoretto produced not a sketch but a picture, and got it inserted into its oval. The competitors remonstrated, not unnaturally; but the artist, who knew how to play his own game, made a free gift of the picture to the saint, and, as a bylaw of the foundation prohibited the rejection of any gift, it was retained in situ, Tintoretto furnishing gratis the other decorations of the same ceiling.</p>
      <p class="wow fadeInLeft" data-wow-delay=".4s" align="justify">In 1565 he resumed work at the scuola, painting the magnificent Crucifixion, for which a sum of 250 ducats was paid. In 1576 he presented gratis another centre-piece – that for the ceiling of the great hall, representing the Plague of Serpents; and in the following year he completed this ceiling with pictures of the Paschal Feast and Moses striking the Rock accepting whatever pittance the confraternity chose to pay.</p>
      <p class="wow fadeInLeft" data-wow-delay=".4s" align="justify">The next conspicuous event in the professional life of Tintoretto is his enormous labor and profuse self-development on the walls and ceilings of the Scuola di S. Rocco, a building which may now almost be regarded as a shrine reared by Tintoretto to his own genius. The building had been begun in 1525 by the Lombardi, and was very deficient in light, so as to be particularly ill-suited for any great scheme of pictorial adornment. The painting of its interior was commenced in 1560.</p>
      <p  class="wow fadeInRight" data-wow-delay=".4s"><img src="uploads/artists/artists_l-z/tintoretto/Tintoretto_ChristWashingTheFeetOfDisciples.jpg" alt="art" width="auto"></p>
      <div class="boldcap wow fadeInRight" data-wow-delay=".4s">Christ Washing the Feet of his Disciples 1556</div>
      <p class="wow fadeInLeft" data-wow-delay=".4s" align="justify">Tintoretto next launched out into the painting of the entire scuola and of the adjacent church of S. Rocco. He offered in November 1577 to execute the works at the rate of 100 ducats per annum, three pictures being due in each year. This proposal was accepted and was punctually fulfilled, the painters death alone preventing the execution of some of the ceiling-subjects. The whole sum paid for the scuola throughout was 2447 ducats. Disregarding some minor performances, the scuola and church contain fifty-two memorable paintings, which may be described as vast suggestive sketches, with the mastery, but not the deliberate precision, of finished pictures, and adapted for being looked at in a dusky half-light. Adam and Eve, the Visitation, the Adoration of the Magi, the Massacre of the Innocents, the Agony in the Garden, Christ before Pilate, Christ carrying His Cross, and (this alone having been marred by restoration) the Assumption of the Virgin are leading examples in the scuola; in the church, Christ curing the Paralytic.</p>
      <p class="wow fadeInLeft" data-wow-delay=".4s" align="justify">It was probably in 1560, the year in which he began working in the Scuola di S. Rocco, that Tintoretto commenced his numerous paintings in the ducal palace; he then executed there a portrait of the doge, Girolamo Priuli. Other works which were destroyed in the great fire of 1577 succeeded – the Excommunication of Frederick Barbarossa by Pope Alexander III and the Victory of Lepanto.</p>
      <p  class="wow fadeInRight" data-wow-delay=".4s"><img src="uploads/artists/artists_l-z/tintoretto/Tintoretto_PortraitOfAGentlemanInAFur.jpg" alt="art" width="auto"></p>
      <div class="boldcap wow fadeInRight" data-wow-delay=".4s">Portrait of a Gentleman in a Fur 1550</div>
      <p class="wow fadeInLeft" data-wow-delay=".4s" align="justify">After the fire Tintoretto started afresh, Paolo Veronese being his colleague; their works have for the most part been disastrously and disgracefully retouched of late years, and some of the finest monuments of pictorial power ever produced are thus degraded to comparative unimportance.</p>
      <p class="wow fadeInLeft" data-wow-delay=".4s" align="justify">In the Sala deilo Scrutinio Tintoretto painted the Capture of Zara from the Hungarians in 1346 amid a Hurricane of Missiles; in the hail of the senate, Venice, Queen of the Sea; in the hall of the college, the Espousal of St Catherine to Jesus; in the Sala dell Anticollegio, four extraordinary masterpieces – Bacchus, with Ariadne crowned by Venus, the Three Graces and Mercury, Minerva discarding Mars, and the Forge of Vulcan which were painted for fifty ducats each, besides materials, towards 1578; in the Antichiesetta, St George and St Nicholas, with St Margaret (the female figure is sometimes termed the princess whom St George rescued from the dragon), and St Jerome and St Andrew; in the hall of the great council, nine large compositions, chiefly battle-pieces.</p>
      <p class="wow fadeInLeft" data-wow-delay=".4s" align="justify">We here reach the crowning production of Tintoretto’s life, the last picture of any considerable importance which he executed, the vast Paradise, in size 74 ft. by 30, reputed to be the largest painting ever done upon canvas. It is a work so stupendous in scale, so colossal in the sweep of its power, so reckless of ordinary standards of conception or method, so pure an inspiration of a soul burning with passionate visual imagining and a hand magical to work in shape and color, that it has defied the connoisseurship of three centuries, and has generally (though not with its first Venetian contemporaries) passed for an eccentric failure; while to a few eyes it seems to be so transcendent a monument of human faculty applied to the art pictorial as not to be viewed without awe.</p>
      <p  class="wow fadeInRight" data-wow-delay=".4s"><img src="uploads/artists/artists_l-z/tintoretto/Tintoretto_TheBaptismOfChrist1570.jpg" alt="art" width="auto"></p>
      <div class="boldcap wow fadeInRight" data-wow-delay=".4s">The Bapstism of Christ 1570</div>
      <p class="wow fadeInLeft" data-wow-delay=".4s" align="justify">While the commission for this huge work was yet pending and unassigned Tintoretto was wont to tell the senators that he had prayed to God that he might be commissioned for it, so that paradise itself might perchance be his recompense after death. Upon eventually receiving the commission in 1588 he set up his canvas in the Scuola della Misericordia and worked indefatigably at the task, making many alterations and doing various heads and costumes direct from nature.</p>
      <p class="wow fadeInLeft" data-wow-delay=".4s" align="justify">When the picture had been nearly completed he took it to its proper place and there finished it, assisted by his son Domenico for details of drapery, etc. All Venice applauded the superb achievement, which has since suffered from neglect, but little from restoration. Tintoretto was asked to name his own price, but this he left to the authorities. They tendered a handsome amount; he is said to have abated something from it, an incident perhaps more telling of his lack of greed than earlier cases where he worked for nothing at all.</p>
      <p  class="wow fadeInRight" data-wow-delay=".4s"><img src="uploads/artists/artists_l-z/tintoretto/Tintoretto_PortraitofVincenzo.jpg" alt="art" width="auto"></p>
      <div class="boldcap wow fadeInRight" data-wow-delay=".4s">Portrait of Vincenzo Morosini 1580</div>
      <p class="wow fadeInLeft" data-wow-delay=".4s" align="justify">After the completion of the Paradise Tintoretto rested for a while, and he never undertook any other work of importance, though there is no reason to suppose that his energies were exhausted had his days been a little prolonged.</p>
      <p class="wow fadeInLeft" data-wow-delay=".4s" align="justify">In 1592 he became a member of the Scuola di Mercanti. He was seized with an attack in the stomach, complicated with fever, which prevented him from sleeping and almost from eating for a fortnight, and on the May 31, 1594 he died. He was buried in the church of the Madonna dell Orto by the side of his favorite daughter Marietta, who had died in 1590, age thirty; there is a well-known tradition that as she lay dead the heart-stricken father painted her portrait.</p>
      <p class="wow fadeInLeft" data-wow-delay=".4s" align="justify">Marietta had herself been a portrait-painter of considerable skill, as well as a musician, vocalist and instrumentalist; but few of her works are now traceable. It is said that up to the age of fifteen she used to accompany and assist her father at his work, dressed as a boy; eventually she married a jeweler, Mario Augusta. In 1866 the grave of the Vescovi and Tintoretto was opened, and the remains of nine members of the joint families were found in it; a different locality, the chapel on the right of the choir, was then assigned to the grave.</p>
      <p  class="wow fadeInRight" data-wow-delay=".4s"><img src="uploads/artists/artists_l-z/tintoretto/Tintoretto_TheWeddingFeast.jpg" alt="art" width="auto"></p>
      <div class="boldcap wow fadeInRight" data-wow-delay=".4s">The Wedding Feast</div>
      <p class="wow fadeInLeft" data-wow-delay=".4s" align="justify">Of pupils Tintoretto had very few; his two sons and Martin de Vos of Antwerp were among them. His son Domenico (1562-1637), whom we have already had the occasion to mention, frequently assisted his father in the groundwork of great pictures. He himself painted a multitude of works, many of them of a very large scale; they would at best be mediocre, and, coming from the son of Tintoretto, are exasperating; still, he must be regarded as a considerable sort of pictorial practitioner in his way. There are reflections of Tintoretto to be found in the Greek painter of the Spanish Renaissance El Greco, who likely saw his works during a stay in Venice.</p>
      <p class="wow fadeInLeft" data-wow-delay=".4s" align="justify">Tintoretto scarcely ever traveled out of Venice. He loved all the arts, played in youth the lute and various instruments, some of them of his own invention, and designed theatrical costumes and properties, was versed in mechanics and mechanical devices, and was a very agreeable companion. For the sake of his work he lived in a most retired fashion, and even when not painting was wont to remain in his working room surrounded by casts. Here he hardly admitted any, even intimate friends, and he kept his modes of work secret, save as regards his assistants. He abounded in pleasant witty sayings whether to great personages or to others, but no smile hovered on his lips.</p>
      <p class="wow fadeInLeft" data-wow-delay=".4s" align="justify">Out of doors his wife made him wear the robe of a Venetian citizen; if it rained she tried to indue him with an outer garment, but this he resisted. She would also when he left the house wrap up money for him in a handkerchief, and on his return expected an account of it; Tintoret’s accustomed reply was that he had spent it in alms to the poor or to prisoners.</p>
      <p  class="wow fadeInRight" data-wow-delay=".4s"><img src="uploads/artists/artists_l-z/tintoretto/Tintoretto_SusannaAtHerBath.jpg" alt="art" width="auto"></p>
      <div class="boldcap wow fadeInRight" data-wow-delay=".4s">Susanna at her Bath 1560</div>
      <p class="wow fadeInLeft" data-wow-delay=".4s" align="justify">An agreement is extant showing that he undertook to finish in two months two historical pictures each containing twenty figures, seven being portraits. The number of his portraits is enormous; their merit is unequal, but the really fine ones cannot be surpassed. Sebastiano del Piombo remarked that Tintoretto could paint in two days as much as himself in two years; Annibale Carracci that Tintoretto was in many pictures equal to Titian, in others inferior to Tintoretto. This was the general opinion of the Venetians, who said that he had three pencils – one of gold, the second of silver and the third of iron.</p>
      <p class="wow fadeInLeft" data-wow-delay=".4s" align="justify">A comparison of Tintoretto’s final The Last Supper with Leonardo da Vinci’s treatment of the same subject provides an instructive demonstration of how artistic styles evolved over the course of the Renaissance. Leonardo’s is all classical repose. The disciples radiate away from Christ in almost-mathematical symmetry. In the hands of Tintoretto, the same event becomes dramatically distorted, as the human figures are overwhelmed by the eruption of beings from the spirit world. In the restless dynamism of his composition, his dramatic use of light, and his emphatic perspective effects, Tintoretto seems a baroque artist ahead of his time.</p>
      <p  class="wow fadeInRight" data-wow-delay=".4s"><img src="uploads/artists/artists_l-z/tintoretto/Tintoretto_TheLastSupper1594.jpg" alt="art" width="auto"></p>
      <div class="boldcap wow fadeInRight" data-wow-delay=".4s">The Last Supper 1594</div>
      <p class="wow fadeInLeft" data-wow-delay=".4s" align="justify">Still wondering about an Italian painting in your family collection? <a href="https://www.artexpertswebsite.com/contact/contact1.php">Contact us</a>…it could be by Tintoretto.</p>
      
      
    </div>
    
    
    <?php include($_SERVER['DOCUMENT_ROOT']."/includes/right-sidebar.php");  ?>
    
    <!-- / main body -->

  </main>
</div>



<?php include($_SERVER['DOCUMENT_ROOT']."/includes/footer.php");  ?>



<?php include($_SERVER['DOCUMENT_ROOT']."/includes/copyright.php");  ?>


<a id="backtotop" href="#top"><i class="fa fa-chevron-up"></i></a>
<!-- JAVASCRIPTS -->
<script src="../layout/scripts/jquery.min.js"></script>
<script src="../layout/scripts/jquery.backtotop.js"></script>
<script src="../layout/scripts/jquery.mobilemenu.js"></script>
<script src="https://cdn.jsdelivr.net/npm/cookieconsent@3/build/cookieconsent.min.js" data-cfasync="false"></script>
<script>
window.cookieconsent.initialise({
  "palette": {
    "popup": {
      "background": "#474747"
    },
    "button": {
      "background": "#9d0552"
    }
  },
  "content": {
    "message": "This website uses cookies to improve your experience. We'll assume you're ok with this, but you can opt-out if you wish.",
    "dismiss": "Accept Cookies"
  }
});
</script>

</body>
</html>