<!DOCTYPE html>

<html lang="en">
<!-- To declare your language - read more here: https://www.w3.org/International/questions/qa-html-language-declarations -->
<head>
<title>Paolo Veronese | Art Experts</title>
<meta name="description" content="Paolo Veronese art authentication, Paolo Veronese appraisal, Full painting authentications. Certificate of authenticity (COA). we will sell your Paolo Veronese.">
<meta name=”robots” content="index, follow">





















<link href="../layout/styles/test-layout.css" rel="stylesheet" type="text/css" media="all">
<link rel="stylesheet" type="text/css" href="https://cdn.jsdelivr.net/npm/cookieconsent@3/build/cookieconsent.min.css" />
<!-- Global site tag (gtag.js) - Google Analytics -->
<script async src="https://www.googletagmanager.com/gtag/js?id=G-NZ7GKNVDYS"></script>
<script>
  window.dataLayer = window.dataLayer || [];
  function gtag(){dataLayer.push(arguments);}
  gtag('js', new Date());

  gtag('config', 'G-NZ7GKNVDYS');
</script>
<link rel="canonical" href="<?php echo 'https://' . $_SERVER['HTTP_HOST'] . $_SERVER['REQUEST_URI']; ?>"><meta name="viewport" content="width=device-width, initial-scale=1.0"></head>

<?php include($_SERVER['DOCUMENT_ROOT']."/includes/header2.php");  ?>



<div class="wrapper bgded overlay" style="display:none;background-image:url(../images/demo/backgrounds/09.png);">
  <div id="breadcrumb" class="hoc clear"> 
    
    
  </div>
</div>



<div class="wrapper row3">
  <main class="hoc container clear"> 
    <!-- main body -->
    
    <div class="content three_quarter first" id="three_connn"> 
      

      
      
      <div>
        <h1 class="wow fadeInLeft" data-wow-delay=".4s">Paolo Veronese (1528 – 1588)</h1>
      </div>
      <p class="wow fadeInLeft" data-wow-delay=".4s" align="justify">Paolo Veronese art authentication. <a href="https://www.artexpertswebsite.com/appraisal/painting-appraisal.php">Paolo Veronese appraisal</a>. <a href="https://www.artexpertswebsite.com/authentication/certificate-of-authenticity.php">Paolo Veronese certificates of authenticity (COA)</a>.  Paolo Veronese analysis, <a href="https://www.artexpertswebsite.com/authentication/provenance-research.php">research</a>, <a href="https://www.artexpertswebsite.com/authentication/scientific-tests.php">scientific tests</a>, <a href="https://www.artexpertswebsite.com/authentication.php">full art authentications</a>. We will help you sell your Paolo Veronese or we will sell it for you.</p>
      <p  class="wow fadeInRight" data-wow-delay=".4s"><img src="uploads/artists/artists_l-z/veronese/Veronese_TheEternalFather.jpg" alt="art" width="auto" height="auto"></p>
      <div class="boldcap wow fadeInRight" data-wow-delay=".4s">The Eternal Father</div>
      <p class="wow fadeInLeft" data-wow-delay=".4s" align="justify">Paolo Veronese was a prolific and important painter of the Renaissance in Venice, famous for paintings such as The Wedding at Cana and The Feast in the House of Levi. He adopted the name Paolo Cagliari or Paolo Caliari, and became known as “Veronese” from his birthplace in Verona.</p>
      <p  class="wow fadeInRight" data-wow-delay=".4s"><img src="uploads/artists/artists_l-z/veronese/Veronese_FeastInTheHouseOfLevi.jpg" alt="art" width="auto"></p>
      <div class="boldcap wow fadeInRight" data-wow-delay=".4s">The Feast in the House of Levi 1573</div>
      <p class="wow fadeInLeft" data-wow-delay=".4s" align="justify">Veronese, Titian, and Tintoretto comprise the triumvirate of pre-eminent Venetian painters of the late Renaissance (1500s). Veronese is known as a supreme colorist, and for his illusionistic decorations in both fresco and oil. His most famous works are elaborate narrative cycles, executed in a dramatic and colorful Mannerist style, full of majestic architectural settings and glittering pageantry. His large paintings of biblical feasts executed for the refectories of monasteries in Venice and Verona are especially notable. His brief testimony with the Inquisition is often quoted for its insight into contemporary painting technique.</p>
      <p  class="wow fadeInRight" data-wow-delay=".4s"><img src="uploads/artists/artists_l-z/veronese/Veronese_PortraitOfAMan.jpg" alt="art" width="auto" height="auto"></p>
      <div class="boldcap wow fadeInRight" data-wow-delay=".4s">Portrait of a Man 1550s</div>
      <p class="wow fadeInLeft" data-wow-delay=".4s" align="justify">The census in Verona attests that Veronese was born some time in 1528 to a stonecutter named Gabriele, and his wife Catherina. By the age of fourteen Veronese apprenticed with the local master Antonio Badile, and perhaps with Giovanni Francesco Caroto. An altarpiece painted by Badile in 1543 includes striking passages that were most likely the work of his fifteen-year-old apprentice; Veronese’s precocious gifts soon surpassed the level of the workshop, and by 1544 he was no longer residing with Badile. Though trained in the culture of Mannerism then popular in Parma, he soon developed his own preference for a more radiant palette.</p>
      <p  class="wow fadeInRight" data-wow-delay=".4s"><img src="uploads/artists/artists_l-z/veronese/Veronese_LucretiaStabbingHerself1583.jpg" alt="art" width="auto"></p>
      <div class="boldcap wow fadeInRight" data-wow-delay=".4s">Lucretia Stabbing Herself 1583-1584</div>
      <p class="wow fadeInLeft" data-wow-delay=".4s" align="justify">He then moved briefly to Mantua in 1548 (where he created frescoes in that city’s Duomo) before ultimately settling in Venice. His first Venetian commission was a Sacra Conversazione from San Francesco della Vigna (c.1552). In 1553, he obtained his first state commission, the fresco decoration of the Sala dei Cosiglio dei Dieci and adjoining Sala dei Tre Capi del Consiglio. He then painted a History of Esther in the ceiling for the church of San Sebastiano. It was his ceiling paintings for San Sebastiano, the Ducal Palace, and the Marciana Library, (the last for which Titian awarded him a prize), that established him as a master among his Venetian contemporaries. Already these works indicate Veronese’s mastery for referencing both the subtle foreshortening of the figures of Correggio and the heroism of those by Michelangelo.</p>
      <p  class="wow fadeInRight" data-wow-delay=".4s"><img src="uploads/artists/artists_l-z/veronese/Veronese_AllegoricalPainting,ThreeGraces.jpg" alt="art" width="auto"></p>
      <div class="boldcap wow fadeInRight" data-wow-delay=".4s">Allegorical Painting Three Graces</div>
      <p class="wow fadeInLeft" data-wow-delay=".4s" align="justify">By 1556 Veronese was commissioned to paint the first of his monumental banquet scenes, the Feast in the House of Simon, which would not be concluded until 1570. However, owing to its scattered composition and lack of focus, it was not his most successful refectory mural. In the late 1550s, during a break in his work for San Sebastiano, Veronese decorated the Villa Barbaro in Maser, a newly-finished building by the architect Andrea Palladio. The frescoes were designed to unite humanistic culture with Christian spirituality; wall paintings included portraits of the Barbaro family, and the ceilings opened to blue skies and mythological figures. Veronese’s decorations employed complex perspective and trompe l’oeil, and resulted in a luminescent and inspired visual poetry. The encounter between architect and artist was a triumph.</p>
      <p class="wow fadeInLeft" data-wow-delay=".4s" align="justify">The Wedding at Cana, painted in 1562-1563, was commissioned for Palladio’s refectory in San Giorgio Maggiore. As in the other banquet pictures, the scene reflects the festivities then current to Venetian life. The painting is immense: more than a hundred figures, including recognizable portraits of Titian, Tintoretto, and Veronese himself, are staged upon a canvas surface nearly ten meters wide. The foreground celebration, a frieze of figures painted in the most shimmering finery, is flanked by two sets of stairs leading back to a terrace, Roman colonnades, and a brilliant sky.</p>
      <p  class="wow fadeInRight" data-wow-delay=".4s"><img src="uploads/artists/artists_l-z/veronese/Veronese_TheWeddingAtCanaa.jpg" alt="art" width="auto"></p>
      <div class="boldcap wow fadeInRight" data-wow-delay=".4s">The Wedding at Cana 1562-1563</div>
      <p class="wow fadeInLeft" data-wow-delay=".4s" align="justify">In the refectory paintings, as in The Family of Darius before Alexander (1565-1570), Veronese arranged the architecture to run mostly parallel to the picture plane, accentuating the processional character of the composition. The artist’s decorative genius was to recognize that dramatic perspectival effects would have been tiresome in a living room or chapel, and that the narrative of the picture could best be absorbed as a colorful diversion.</p>
      <p  class="wow fadeInRight" data-wow-delay=".4s"><img src="uploads/artists/artists_l-z/veronese/Veronese_TheAscensionOfChrist.jpg" alt="art" width="auto" height="auto"></p>
      <div class="boldcap wow fadeInRight" data-wow-delay=".4s">The Ascension of Christ</div>
      <p class="wow fadeInLeft" data-wow-delay=".4s" align="justify">These paintings offer little in the representation of emotion; rather, they illustrate the carefully composed movement of their subjects along a primarily horizontal axis. Most of all they are about the incandescence of light and color. The exaltation of such visual effects may have been a reflection of the artist’s personal well-being, for in 1565 Veronese married Elena Badile, the daughter of his first master, and by whom he would eventually have four sons and a daughter.</p>
      <p  class="wow fadeInRight" data-wow-delay=".4s"><img src="uploads/artists/artists_l-z/veronese/Veronese_SodohmAndGomorrah.jpg" alt="art" width="auto" height="auto"></p>
      <div class="boldcap wow fadeInRight" data-wow-delay=".4s">Sodom and Gomorrah</div>
      <p class="wow fadeInLeft" data-wow-delay=".4s" align="justify">of Levi for the rear wall of the refectory in San Zanipoli (Santi Giovanni e Paolo). The painting was originally intended as a depiction of the Last Supper, designed to replace a canvas by Titian that had been lost in a fire. It measured more than five meters high and over twelve meters wide, depicted another Venetian celebration and was a culmination of his banquet scenes, which this time included not only the Last Supper, but also German soldiers, comic dwarves, and a variety of animals; in short, the exotica which were standard to his narratives. Even as Veronese’s use of color attained greater intensity and luminosity, his attention to narrative, human sentiment, and a more subtle and meaningful physical interplay between his figures became evident.</p>
      <p  class="wow fadeInRight" data-wow-delay=".4s"><img src="uploads/artists/artists_l-z/veronese/Veronese_TheBattleOfLepanto.jpeg" alt="art"></p>
      <div class="boldcap wow fadeInRight" data-wow-delay=".4s">The Battle of Lepanto 1572</div>
      <p class="wow fadeInLeft" data-wow-delay=".4s" align="justify">That the subject was indeed a Last Supper, and then some, was not lost on the Inquisition. A decade earlier the monks who commissioned the Wedding at Cana had requested that the artist squeeze the maximum number of figures into the painting, but the Counter-Reformation had since exerted its influence in Venice, and in July of 1573 Veronese was summoned to explain the inclusion of extraneous and indecorous details in the painting. The tone of the hearing itself was cautionary rather than punitive; Veronese explained that “we painters take the same liberties as poets and madmen”, and rather than repaint the picture, he simply and pragmatically re-titled it to the less sacramental version by which it is known today.</p>
      <p  class="wow fadeInRight" data-wow-delay=".4s"><img src="uploads/artists/artists_l-z/veronese/Veronese_TwoWomen.jpg" alt="art" width="auto" height="auto"></p>
      <div class="boldcap wow fadeInRight" data-wow-delay=".4s">Two Women</div>
      <p class="wow fadeInLeft" data-wow-delay=".4s" align="justify">In addition to the ceiling creations and wall paintings, Veronese also produced altarpieces (The Consecration of Saint Nicholas, 1561-2, National Gallery), paintings on mythological subjects (Venus and Mars, 1578, Metropolitan Museum of Art), and portraits (Portrait of a Lady, 1555, Louvre). A significant number of compositional sketches in pen, ink and wash, figure studies in chalk, and chiaroscuro modelli and ricordi are in circulation. Veronese was one of the first painters whose drawings were sought by collectors during his lifetime.</p>
      <p  class="wow fadeInRight" data-wow-delay=".4s"><img src="uploads/artists/artists_l-z/veronese/Veronese_TheAllegoryOfWisdomAndStrenght.jpg" alt="art" width="auto" height="auto"></p>
      <div class="boldcap wow fadeInRight" data-wow-delay=".4s">Allegory of Wisdom and Strenght 1580</div>
      <p class="wow fadeInLeft" data-wow-delay=".4s" align="justify">He headed a family workshop, including his brother Benedetto, sons Carlo and Gabriele, that remained active after his death in Venice in 1588. Among his pupils were his contemporary Giovanni Battista Zelotti and later Giovanni Antonio Fasolo and Luigi Benfatto (also called dal Friso; 1559-1611).</p>
      <p  class="wow fadeInRight" data-wow-delay=".4s"><img src="uploads/artists/artists_l-z/veronese/Veronese_DivesAndLazarus.jpg" alt="art" width="auto"></p>
      <div class="boldcap wow fadeInRight" data-wow-delay=".4s">Dives and Lazarus</div>
      <p class="wow fadeInLeft" data-wow-delay=".4s" align="justify">In 1648 Carlo Ridolfi wrote of the Feast in the House of Levi that it gave rein to joy, made beauty majestic, made laughter itself more festive.</p>
      <p class="wow fadeInLeft" data-wow-delay=".4s">A modern assessment of Veronese’s achievement is worth quoting at length:<br>
        The French had no doubts, as the critic Théophile Gautier wrote in 1860, that Veronese was the greatest colorist who ever lived–greater than Titian, Rubens, or Rembrandt because he established the harmony of natural tones in place of the modeling in dark and light that remained the method of academic chiaroscuro. Delacroix wrote that Veronese made light without violent contrasts, “which we are always told is impossible, and maintained the strength of hue in shadow.”</p>
      <p class="wow fadeInLeft" data-wow-delay=".4s">This innovation could not be better described. Veronese’s bright outdoor harmonies enlightened and inspired the whole nineteenth century. He was the foundation of modern painting. But whether his style is in fact naturalistic, as the Impressionists thought, or a more subtle and beautiful imaginative invention must remain a question for each age to answer for itself.</p>
      <p  class="wow fadeInRight" data-wow-delay=".4s"><img src="uploads/artists/artists_l-z/veronese/Veronese_Crucifixion.jpg" alt="art" width="auto"></p>
      <div class="boldcap wow fadeInRight" data-wow-delay=".4s">Crucifixion 1580</div>
      <p class="wow fadeInLeft" data-wow-delay=".4s" align="justify">Still wondering about and Italian painting in your family collection? <a href="https://www.artexpertswebsite.com/contact/contact1.php">Contact us</a>…it could be by Paolo Veronese.</p>
      
      
    </div>
    
    
    <?php include($_SERVER['DOCUMENT_ROOT']."/includes/right-sidebar.php");  ?>
    
    <!-- / main body -->

  </main>
</div>



<?php include($_SERVER['DOCUMENT_ROOT']."/includes/footer.php");  ?>



<?php include($_SERVER['DOCUMENT_ROOT']."/includes/copyright.php");  ?>


<a id="backtotop" href="#top"><i class="fa fa-chevron-up"></i></a>
<!-- JAVASCRIPTS -->
<script src="../layout/scripts/jquery.min.js"></script>
<script src="../layout/scripts/jquery.backtotop.js"></script>
<script src="../layout/scripts/jquery.mobilemenu.js"></script>
<script src="https://cdn.jsdelivr.net/npm/cookieconsent@3/build/cookieconsent.min.js" data-cfasync="false"></script>
<script>
window.cookieconsent.initialise({
  "palette": {
    "popup": {
      "background": "#474747"
    },
    "button": {
      "background": "#9d0552"
    }
  },
  "content": {
    "message": "This website uses cookies to improve your experience. We'll assume you're ok with this, but you can opt-out if you wish.",
    "dismiss": "Accept Cookies"
  }
});
</script>

</body>
</html>