<!DOCTYPE html>

<html lang="en">
<!-- To declare your language - read more here: https://www.w3.org/International/questions/qa-html-language-declarations -->
<head>
<title>Leonardo da Vinci | Art Experts</title>
<meta name="description" content="Leonardo da Vinci art authentication, Leonardo da Vinci appraisal, Full painting authentications. Certificate of authenticity (COA). we will sell your Leonardo da Vinci.">
<meta name=”robots” content="index, follow">




<link rel="canonical" href="https://www.artexpertswebsite.com/pages/da-vinci.php" />

















<link href="../layout/styles/test-layout.css" rel="stylesheet" type="text/css" media="all">
<link rel="stylesheet" type="text/css" href="https://cdn.jsdelivr.net/npm/cookieconsent@3/build/cookieconsent.min.css" />
<!-- Global site tag (gtag.js) - Google Analytics -->
<script async src="https://www.googletagmanager.com/gtag/js?id=G-NZ7GKNVDYS"></script>
<script>
  window.dataLayer = window.dataLayer || [];
  function gtag(){dataLayer.push(arguments);}
  gtag('js', new Date());

  gtag('config', 'G-NZ7GKNVDYS');
</script>
<meta name="viewport" content="width=device-width, initial-scale=1.0"></head>

<?php include($_SERVER['DOCUMENT_ROOT']."/includes/header2.php");  ?>



<div class="wrapper bgded overlay" style="display:none;background-image:url(../images/demo/backgrounds/09.png);">
  <div id="breadcrumb" class="hoc clear"> 
    
    
  </div>
</div>



<div class="wrapper row3">
  <main class="hoc container clear"> 
    <!-- main body -->
    
    <div class="content three_quarter first" id="three_connn"> 
      

      
      
      <div>
        <h1 class="wow fadeInLeft" data-wow-delay=".4s">Leonardo da Vinci (15 April 1452 – 2 May 1519)</h1>
      </div>
      <p class="wow fadeInLeft" data-wow-delay=".4s">We Perform Leonardo da Vinci art authentication. <a href="https://www.artexpertswebsite.com/appraisal/painting-appraisal.php">Leonardo da Vinci appraisal</a>. <a href="https://www.artexpertswebsite.com/authentication/certificate-of-authenticity.php">Leonardo da Vinci certificates of authenticity (COA)</a>.  Leonardo da Vinci analysis, <a href="https://www.artexpertswebsite.com/authentication/provenance-research.php">research</a>, <a href="https://www.artexpertswebsite.com/authentication/scientific-tests.php">scientific tests</a>, <a href="https://www.artexpertswebsite.com/authentication.php">full art authentications</a>. We will help you sell your Leonardo da Vinci or we will sell it for you.</p>
      <p class="wow fadeInLeft" data-wow-delay=".4s">Leonardo da Vinci set standards for representation, draftsmanship, and aesthetics that dominated the High Renaissance. Leonardo essentially changed the image of the artist, from a craftsman to a learned man with a capacity for creativity and theoretical thinking. His theories and oeuvre dominated European art for the past five hundred years. His Mona Lisa (Louvre, Paris, France) is considered the most famous painting in the world. Leonardo da Vinci was the first Italian artist to paint in oil. Few of his works were actually completed, however, and only a small number survive. (Kemp, M. “Leonardo da Vinci,” Encyclopedia of Italian Renaissance and Mannerist Art, Oxford University Press, 2004, pp. 846-847.)</p>
      <p  class="wow fadeInRight" data-wow-delay=".4s"><img src="uploads/artists/artists_l-z/leonardo/image12.jpg" alt="da Vinci, Study of a Woman, ca. 1487, Galleria delgli Uffizi, Florence, Italy." width="auto" height="auto"></p>
      <div class="boldcap wow fadeInRight" data-wow-delay=".4s">Study of a Woman, ca. 1487, Galleria delgli Uffizi, Florence, Italy.</div>
      <p class="wow fadeInLeft" data-wow-delay=".4s">Leonardo holds a place of honor in Vasari’s (1511-1574) Lives of the Most Excellent Painters, Sculptors, and Architects. Vasari was the first Italian art historian; he invented the term “Renaissance.” Vasari’s biography of Leonardo da Vinci set the tone for both scholarly and popular appreciation of Leonardo da Vinci’s oeuvre. (Clark, K., intro., Lives of the most eminent painters, sculptors, and architects by Giorgio Vasari, translated by Gaston du C. De Vere, Abrams, New York, 1979, pp. xi-xiv.) Leonardo da Vinci’s reputation was high during his own lifetime and has continued unsullied throughout art history.</p>
      <p class="wow fadeInLeft" data-wow-delay=".4s">The broad outlines of Leonardo da Vinci’s biography come from Vasari. Leonardo was born in Florence, the illegitimate child of a prosperous, middle class father and a mother about whom only her name—Caterina—is known. His father was a notary. Leonardo was his father’s first child; his father married four times after Leonardo’s birth. (Goldscheider, L., Leonardo da Vinci, Oxford University Press, Oxford, 1959, pp. 13-20.)</p>
      <p  class="wow fadeInRight" data-wow-delay=".4s"><img src="uploads/artists/artists_l-z/leonardo/stjeromeleonardo.jpg" alt="da Vinci, St. Jerome, ca. 1482, oil on panel, Pinacoteca, Vaticana, Rome."></p>
      <div class="boldcap wow fadeInRight" data-wow-delay=".4s">St. Jerome, ca. 1482, oil on panel, Pinacoteca, Vaticana, Rome.</div>
      <p class="wow fadeInLeft" data-wow-delay=".4s"><strong>First Period in Florence</strong></p>
      <p class="wow fadeInLeft" data-wow-delay=".4s">Leonardo’s father arranged an apprenticeship for Leonardo in the studio of one of the most outstanding sculptors of the time: Andrea del Verrocchio (ca. 1435-88). Verrocchio’s workshop was the largest in Florence. The name “Verrocchio” means true eye. Verrocchio worked mostly in bronze. He was also a painter, but few paintings are ascribed to his hand alone. Verrocchio trained many important painters of the time in addition to Leonardo da Vinci. (Baxandall, M., Painting and Experience of Fifteenth Century Italy: A Primer in Social History of pictorial style. New York, Oxford University Press, 1980, pp. 85-97.) Leonardo da Vinci apprenticed with Verrocchio for ten years.</p>
      <p  class="wow fadeInRight" data-wow-delay=".4s"><img width="auto" src="uploads/artists/artists_l-z/leonardo/FullAnnunciation.jpg" alt="da Vinci, The Annunciation, ca. 1472, painted by Leonardo da Vinci and Andrea del Vecchio, oil and tempera on panel, Galleria delgli Uffizi, Florence, Italy."></p>
      <div class="boldcap wow fadeInRight" data-wow-delay=".4s">The Annunciation, ca. 1472, painted by Leonardo da Vinci and Andrea del Verrocchio, oil and tempera on panel, Galleria delgli Uffizi, Florence, Italy.</div>
      <p class="wow fadeInLeft" data-wow-delay=".4s">In 1472, Leonardo da Vinci joined the Compagnia di San Luca, the fraternity of artists in Florence. (Kemp, Encyclopedia, p. 848.) The Annunciation (Uffizi, Florence) was started during the 1470s, as was the portrait of Ginevra di’ Benci (National Gallery, Washington, DC), who married in 1474. (Brown, D.A., Leonardo da Vinci: Origins of a Genius, Yale University Press, New Haven, 1998, pp. 101-123.)</p>
      <p  class="wow fadeInRight" data-wow-delay=".4s"><img width="auto" src="uploads/artists/artists_l-z/leonardo/Ginevra.jpg" alt="da Vinci, Portrait of Ginevra de' Benci, ca. 1474-5, oil on panel, National Gallery of Art, Washington, DC."></p>
      <div class="boldcap wow fadeInRight" data-wow-delay=".4s">Portrait of Ginevra de’ Benci, ca. 1474-5, oil on panel, National Gallery of Art, Washington, DC.</div>
      <p class="wow fadeInLeft" data-wow-delay=".4s">The altarpiece of The Adoration of the Magi (Uffizi, Florence) was commissioned by the monastery of S Donata in 1481. It remains unfinished, only the under-painting was completed before Leonardo moved to Milan. (Kemp, M. Leonardo, Oxford University Press, New York, 2004, p. 45-52.)</p>
      <p  class="wow fadeInRight" data-wow-delay=".4s"><img width="auto" src="uploads/artists/artists_l-z/leonardo/magi.jpg" alt="da Vinci, The Adoration of the Magi, 1481, oil on panel, Galleria delgli Uffizi, Florence, Italy."></p>
      <div class="boldcap wow fadeInRight" data-wow-delay=".4s">The Adoration of the Magi, 1481, oil on panel, Galleria delgli Uffizi, Florence, Italy.</div>
      <p class="wow fadeInLeft" data-wow-delay=".4s"><strong>First period in Milan</strong></p>
      <p class="wow fadeInLeft" data-wow-delay=".4s">Scholars think Leonardo moved to Milan in about 1481 or 82. A letter he wrote in 1482 survives. In it, Leonardo asks for a job as a military engineer and lute player with il Moro (the ruler) Ludovico Sforza of Milan. Leonardo also proposed to work on a bronze equestrian statue of Ludovico’s father, which Leonardo never finished. (Brown, pp. 183 and 190.)</p>
      <p class="wow fadeInLeft" data-wow-delay=".4s">Under contract to the Sforza family during the 1480s, Leonardo did a portrait of Ludovico Sforza’s mistress Cecilia Gallerani: Portrait of a Lady with an Ermine (KrakÃ³w, Czartoryski Collection) (Pope-Hennessy, J, The Portrait in the Renaissance, New York, 1966, pp. 72-77.)</p>
      <p  class="wow fadeInRight" data-wow-delay=".4s"><img src="uploads/artists/artists_l-z/leonardo/ladywithermine.jpg" alt="da Vinci, Lady with an Ermine, ca. 1489-90, oil on panel, Czartoryski Museum, KrakÃ³w, Poland."></p>
      <div class="boldcap wow fadeInRight" data-wow-delay=".4s">Lady with an Ermine, ca. 1489-90, oil on panel, Czartoryski Museum, KrakÃ³w, Poland.</div>
      <p class="wow fadeInLeft" data-wow-delay=".4s">Leonardo contracted with the de’ Predis family to create an altarpiece for the church at S Francesco Grande, Milan. The contract specifies that the paintings of the Virgin was to be done in oil. (Kemp, Encyclopedia, p. 846.)</p>
      <p class="wow fadeInLeft" data-wow-delay=".4s">The altarpiece became an on-going legal battle. (Baxandall, M., pp. 21-25.) Out of this ordeal emerged the Virgin of the Rocks (Louvre, Paris). According to some scholars, Leonardo started another version of Virgin of the Rocks (both also known as Madonna of the Rocks) at the National Gallery in London during this time.</p>
      <p  class="wow fadeInRight" data-wow-delay=".4s"><img src="uploads/artists/artists_l-z/leonardo/madonnaoftherocks.jpg" alt="da Vinci, Madonna of the Rocks, 1483-6, oil on panel transferred to canvas, Louvre, Paris."></p>
      <div class="boldcap wow fadeInRight" data-wow-delay=".4s">Madonna of the Rocks, 1483-6, oil on panel transferred to canvas, Louvre, Paris.</div>
      <p class="wow fadeInLeft" data-wow-delay=".4s">Leonardo worked on the fresco of The Last Supper in 1495. Currently in desperate condition, and poorly restored, the fresco was considered the most important painting in the world until its condition irreversibly deteriorated in the nineteenth century. (Baxandall, M., pp. 143-5.)</p>
      <p class="wow fadeInLeft" data-wow-delay=".4s">Many of Leonardo’s notebook sketches of fortresses, flying machines, waterworks, anatomical studies, plants, birds, clouds were from his first period in Milan. (Kemp, M., Leonardo da Vinci, the marvelous works of nature and man, Harvard University Press, Cambridge, MA, 1981, pp. 45-57.) He stayed in Milan until the French invaded in 1499.</p>
      <p class="wow fadeInLeft" data-wow-delay=".4s"><strong>Second Period in Florence</strong></p>
      <p class="wow fadeInLeft" data-wow-delay=".4s">Leonardo went home to Florence in the spring of 1500 and had to find work quickly. The letters of noblewoman Isabella d’Este to Leonardo show the variety of projects he considered, most of which he never undertook. (Goldscheider, pp. 22-24.) Of those he started, most were unfinished: examples of such proposed but never executed projects were a painting of Christ as a child/young man and various portraits of important people of the time in Florence. (“Leonardo da Vinci,” Oxford Dictionary of Art, p. 285.)</p>
      <p  class="wow fadeInRight" data-wow-delay=".4s"><img width="auto" src="uploads/artists/artists_l-z/leonardo/workonpaper.jpg" alt="da Vinci, Study of a Horse, undated, Galleria delgli Uffizi, Florence, Italy."></p>
      <div class="boldcap wow fadeInRight" data-wow-delay=".4s">Study of a Horse, undated, Galleria delgli Uffizi, Florence, Italy.</div>
      <p class="wow fadeInLeft" data-wow-delay=".4s">The cartoon (preliminary drawing) for Virgin and Child with St. Anne and Lamb dates from the second Florentine period, as do less realized drawings for Madonna of the Yarnwinder. (Kemp, M., “From Scientific Examination to the Renasissance Market: The Case of Leonardo da Vinci’s ‘Madonna of the Yarnwinder,'” Journal of Medieval and Renaissance Studies, vol. 24, no. 2, Spring 1994, p. 260-63.)</p>
      <p class="wow fadeInLeft" data-wow-delay=".4s">In 1502, Leonardo became chief engineer and architect for Cesare Borgia. This job required extensive travel. Map of Imola (Windsor Castle) was produced during this period. (Kemp, Encyclopedia, p. 848.)</p>
      <p  class="wow fadeInRight" data-wow-delay=".4s"><img src="uploads/artists/artists_l-z/leonardo/img079.jpg" alt="da Vinci, Study of a Woman, undated, Galleria delgli Uffizi, Florence, Italy."></p>
      <div class="boldcap wow fadeInRight" data-wow-delay=".4s">Study of a Woman, undated, Galleria delgli Uffizi, Florence, Italy.</div>
      <p class="wow fadeInLeft" data-wow-delay=".4s">In late 1502, Leonardo started the wall-painting of Battle of Anghiari meant to celebrate the victory of Florence over Milan in 1440. In 1504, Michelangelo was commissioned to paint the companion piece: the Battle of Cascina. Neither picture was completed. Leonardo was called away in 1504 to help the Borgias plan fortresses. Most of the Battle of Anghiari, however, was completed by Leonardo, though it was destroyed in the 1560s. (Goldscheider, p. 23 and 28.)</p>
      <p class="wow fadeInLeft" data-wow-delay=".4s">Mona Lisa (probably started in 1501 or 2) is the best known painting of Leonardo’s second Florentine period. Vasari first proposed that the sitter was the wife of Francesco del Giocondo, Madonna Lisa. The identity of the sitter was finally affirmed by a note written by a contemporary of Leonardo da Vinci’s discovered at University of Heidelberg Library in 2005. (“Mona Lisa’s true identity,” National Geographic News, 15 January 2008, online edition accessed 1 November 2009.)</p>
      <p class="wow fadeInLeft" data-wow-delay=".4s">The portrait of Mona Lisa was revolutionary. During the early sixteenth century, women were conventionally shown adorned by expensive jewels and fashionable clothes. Women were posed in profile. Leonardo showed Mona Lisa wearing no jewelry, facing the viewer directly, in a three-quarter pose. Viewers are often surprised by its diminutive size—30 x 21 inches (77 x 53 cm.) The painting is on a poplar support. (“Leonardo da Vinci,” Oxford Dictionary of Art, 1998, p. 285)</p>
      <p  class="wow fadeInRight" data-wow-delay=".4s"><img src="uploads/artists/artists_l-z/leonardo/Mona_Lisa.jpg" alt="da Vinci, Mona Lisa, ca. 1503-6, oil on panel, Louvre, Paris, France."></p>
      <div class="boldcap wow fadeInRight" data-wow-delay=".4s">Mona Lisa, ca. 1503-6, oil on panel, Louvre, Paris, France.</div>
      <p class="wow fadeInLeft" data-wow-delay=".4s"><strong>Second period in Milan</strong></p>
      <p class="wow fadeInLeft" data-wow-delay=".4s">Leonardo returned to Milan in the summer of 1508 and was apparently an architect for the French governor of Milan, though none of his plans survive.</p>
      <p class="wow fadeInLeft" data-wow-delay=".4s">This was the period of his most advanced work in geometry and human anatomy. Many scholars believe Leonardo painted St. John the Baptist in about 1509. (Kemp, Encyclopedia, p. 846.)</p>
      <p  class="wow fadeInRight" data-wow-delay=".4s"><img src="uploads/artists/artists_l-z/leonardo/baptism.jpg" alt="da Vinci, Baptism, by Leonardo da Vinici and Andrea del Verrochio, (ca. 1472-75); Galleria degli, Uffizi, Florence, Italy."></p>
      <div class="boldcap wow fadeInRight" data-wow-delay=".4s">Baptism, by Leonardo da Vinici and Andrea del Verrocchio, (ca. 1472-75); Galleria degli, Uffizi, Florence, Italy.</div>
      <p class="wow fadeInLeft" data-wow-delay=".4s"><strong>Florence, Rome, France</strong></p>
      <p class="wow fadeInLeft" data-wow-delay=".4s">Leonardo went back to Florence in 1513. He was hired by Duke Giuliano de Medici for military projects in Rome. Leonardo’s sketches from this period show an intensified interest in fluid mechanics, geometry, and optics. (Goldscheider, pp. 138-41.)</p>
      <p class="wow fadeInLeft" data-wow-delay=".4s">King Francis I invited Leonardo to join his court as “first painter and engineer.” Leonardo spent the rest of his life near Amboise at the Chateau de Cloux. Leonardo was in fragile health and had a partially-paralyzing stroke in about 1517. Scholars believe that assistants did much of painting from this last period of his life. Francecso Melzi, one of Leonardo’s best-known assistants, was mentioned in Leonardo’s will. Leonardo is buried in Amboise, France. (Oxford Dictionary of Art, Oxford University Press, 1988, pp. 185-86.)</p>
      <p  class="wow fadeInRight" data-wow-delay=".4s"><img src="uploads/artists/artists_l-z/leonardo/benoismadonna.jpg" alt="da Vinci, Benois Madonna, 1478, Hermitage Museum, St. Petersburg, Russia."></p>
      <div class="boldcap wow fadeInRight" data-wow-delay=".4s">Benois Madonna, 1478, Hermitage Museum, St. Petersburg, Russia.</div>
      <p  class="wow fadeInRight" data-wow-delay=".4s"><img width="auto" src="uploads/artists/artists_a-k/leonardoaddition/stjohn.jpg" alt="da Vinci, Leonardo da Vinci, "></p>
      <div class="boldcap wow fadeInRight" data-wow-delay=".4s">Leonardo da Vinci, “St. John the Baptist,” (1513-6), oil on panel, 69 x 57 cm, Louvre, Paris.</div>
      <p class="wow fadeInLeft" data-wow-delay=".4s">Do you think you own a picture by Leonardo da Vinci? We authenticate, attribute and appraise any work by da Vinci.</p>
      <p class="wow fadeInLeft" data-wow-delay=".4s">Please <a href="https://www.artexpertswebsite.com/contact/contact1.php">contact</a> us for more information on how we can help you with your Leonardo da Vinci: <a href="mailto:info@artexpertswebsite.com">info@artexpertswebsite.com</a>.</p>
      
      
    </div>
    
    
    <?php include($_SERVER['DOCUMENT_ROOT']."/includes/right-sidebar.php");  ?>
    
    <!-- / main body -->

  </main>
</div>



<?php include($_SERVER['DOCUMENT_ROOT']."/includes/footer.php");  ?>



<?php include($_SERVER['DOCUMENT_ROOT']."/includes/copyright.php");  ?>


<a id="backtotop" href="#top"><i class="fa fa-chevron-up"></i></a>
<!-- JAVASCRIPTS -->
<script src="../layout/scripts/jquery.min.js"></script>
<script src="../layout/scripts/jquery.backtotop.js"></script>
<script src="../layout/scripts/jquery.mobilemenu.js"></script>
<script src="https://cdn.jsdelivr.net/npm/cookieconsent@3/build/cookieconsent.min.js" data-cfasync="false"></script>
<script>
window.cookieconsent.initialise({
  "palette": {
    "popup": {
      "background": "#474747"
    },
    "button": {
      "background": "#9d0552"
    }
  },
  "content": {
    "message": "This website uses cookies to improve your experience. We'll assume you're ok with this, but you can opt-out if you wish.",
    "dismiss": "Accept Cookies"
  }
});
</script>

</body>
</html>