<!DOCTYPE html>

<html lang="en">
<!-- To declare your language - read more here: https://www.w3.org/International/questions/qa-html-language-declarations -->
<head>
<title>Andy Warhol | Art Experts</title>
<meta name="description" content="Andy Warhol art authentication, Andy Warhol appraisal, Full painting authentications. Certificate of authenticity (COA). we will sell your Andy Warhol.">
<meta name=”robots” content="index, follow">





















<link href="../layout/styles/test-layout.css" rel="stylesheet" type="text/css" media="all">
<link rel="stylesheet" type="text/css" href="https://cdn.jsdelivr.net/npm/cookieconsent@3/build/cookieconsent.min.css" />
<!-- Global site tag (gtag.js) - Google Analytics -->
<script async src="https://www.googletagmanager.com/gtag/js?id=G-NZ7GKNVDYS"></script>
<script>
  window.dataLayer = window.dataLayer || [];
  function gtag(){dataLayer.push(arguments);}
  gtag('js', new Date());

  gtag('config', 'G-NZ7GKNVDYS');
</script>
<link rel="canonical" href="<?php echo 'https://' . $_SERVER['HTTP_HOST'] . $_SERVER['REQUEST_URI']; ?>"><meta name="viewport" content="width=device-width, initial-scale=1.0"></head>

<?php include($_SERVER['DOCUMENT_ROOT']."/includes/header2.php");  ?>



<div class="wrapper bgded overlay" style="display:none;background-image:url(../images/demo/backgrounds/09.png);">
  <div id="breadcrumb" class="hoc clear"> 
    
    
  </div>
</div>



<div class="wrapper row3">
  <main class="hoc container clear"> 
    <!-- main body -->
    
    <div class="content three_quarter first" id="three_connn"> 
      

      
      
      <div>
        <h1 class="wow fadeInLeft" data-wow-delay=".4s">AUTHENTICATING ANDY WARHOL</h1>
      </div>
      <p class="wow fadeInLeft" data-wow-delay=".4s">We Perform Do you think you own a work by <em><strong>Andy Warhol</strong></em>? We perform <a href="https://www.artexpertswebsite.com/authentication.php">art art authentications</a>, <a href="https://www.artexpertswebsite.com/appraisal/painting-appraisal.php">art appraisals</a>, <a href="https://www.artexpertswebsite.com/authentication/provenance-research.php">art research</a> and provide <a href="https://www.artexpertswebsite.com/authentication/certificate-of-authenticity.php">Certificates of Authenticity</a> (COA) as well as consultations, for all <em><strong>paintings</strong></em> and <em><strong>prints</strong></em> by Andy Warhol.</p>
      <p class="wow fadeInLeft" data-wow-delay=".4s">The <em>Andy Warhol Foundation for the Visual Arts</em> has curtailed its art authentication Board since early 2012.</p>
      <p class="wow fadeInLeft" data-wow-delay=".4s">Without a Certificate of Authenticity (COA) you will not be able to sell, auction, insure, or donate for tax deduction any works by Warhol.</p>
      <p class="wow fadeInLeft" data-wow-delay=".4s">Art Experts has over a decade of successful experience in authenticating works of all kinds by Warhol. We have the resources to thoroughly research and accurately assess anything produced by Andy Warhol. Please send us an e-mail at <a href="mailto:info@artexpertswebsite.com">info@artexpertswebsite.com</a> for more information on how we can assist you with your artwork by Warhol.</p>
      <p  class="wow fadeInRight" data-wow-delay=".4s"><img src="uploads/artists/artists_l-z/warhol/warhol-gold-marilyn.jpg" alt="Gold Marilyn" border="20"></p>
      <div class="boldcap wow fadeInRight" data-wow-delay=".4s">Gold Marilyn<br>
        1962, silk screen on polymer paint on canvas, 83 Â¼ x 57 “<br>
        Museum of Modern Art, New York</div>
      <p class="wow fadeInLeft" data-wow-delay=".4s"><em><strong>Andy Warhol</strong></em> was an American artist who was a central figure in the movement known as Pop Art, short for Popular Artists. According to <em>The Andy Warhol Foundation</em>, he produced over 100,000 pieces of art in paint, film, photographs, prints and other media. His work is considered a bell-weather of the blue-chip art market. Recently his 1963 lithograph of Elizabeth Taylor sold for $662,500, which is 20 times its original estimate.</p>
      <p  class="wow fadeInRight" data-wow-delay=".4s"><img src="uploads/artists/artists_l-z/warhol/warhol-silver-liz.jpg" alt="Silver Liz" border="20"></p>
      <div class="boldcap wow fadeInRight" data-wow-delay=".4s">Silver Liz<br>
        1963, synthetic polymer paint and silk screen on canvas, 40 x 40 Â½”<br>
        The Andy Warhol Museum, Pittsburgh, PA</div>
      <p class="wow fadeInLeft" data-wow-delay=".4s">After a successful career as a commercial illustrator in 1950s New York, Warhol became famous worldwide for his work as a fine artist, a painter, an avant-garde filmmaker, a record producer, an author and a public figure. He is also known for his presence in wildly diverse social circles that included Bohemian street people, distinguished intellectuals, Hollywood celebrities and wealthy aristocrats.</p>
      <p class="wow fadeInLeft" data-wow-delay=".4s">During his long career as an artist of various media, Warhol founded the gossip magazine <em>Interview</em>, wrote many books and adopted the young painter Jean-Michel Basquiat. He produced the band, <em>The Velvet Underground</em>, presenting them to the public as his latest interest and collaborating with them. Some say he even produced people as with the “Warholian Superstar” and the “Warholian Portrait.” He endorsed products, appeared in commercials and made frequent celebrity guest appearances on television shows and in films. He appeared in everything from the <em>Love Boat</em> to <em>Saturday Night Live</em> and the Richard Pryor movie <em>Dynamite Chicken</em>.</p>
      <p class="wow fadeInLeft" data-wow-delay=".4s">Warhol was a controversial figure during his lifetime with his work often derided by critics as a hoax or a “put-on,” partly due to the fact that the essence of Pop Art is not originality but the appropriation of mass-media images and mass-production methods.</p>
      <p class="wow fadeInLeft" data-wow-delay=".4s">And after his death in 1987, he continues to be controversial as the subject of numerous retrospective exhibitions, books and documentary films.</p>
      <p class="wow fadeInLeft" data-wow-delay=".4s">This controversy carries over to the art authentication of his work, which is sometimes complicated. Because Warhol used assistants from very early in his career, it has made it difficult for novices to tell how much involvement Warhol himself had in some his pieces and that which his assistants had.</p>
      <p  class="wow fadeInRight" data-wow-delay=".4s"><img src="uploads/artists/artists_l-z/warhol/warhol-daily-news-screenprint.jpg" alt="Warhol, Daily News" border="20"></p>
      <div class="boldcap wow fadeInRight" data-wow-delay=".4s">Daily News<br>
        1967, screenprint on paper<br>
        The Andy Warhol Museum, Pittsburgh, PA</div>
      <p class="wow fadeInLeft" data-wow-delay=".4s">Much of what influenced Andy Warhol’s art came from his experiences growing up. Andy Warhol was born Andrew Warhola in Pittsburgh, PA, on August 6, 1928. His parents Ondrej (Andrew) Warhola and Justyna (Julia) Warhola were working-class immigrants from Czechoslovak, a village in Slovakia. Their surname was originally spelled Varchola in Europe but was later modified by the couple to Warhola after they immigrated to America following the death of Warhol’s grandparents. His parents spoke their native language at home, which Andy and his two older brothers, John and Paul, understood.</p>
      <p class="wow fadeInLeft" data-wow-delay=".4s">The family was Byzantine Catholic and attended St. John Chrysostom Byzantine Catholic Church. They were religious, often walking several miles a day to their local Byzantine Catholic Church. There a copy of Leonardo da Vinci’s <em>The Last Supper</em> became an inspiration for one of Andy’s most well-known art pieces.</p>
      <p class="wow fadeInLeft" data-wow-delay=".4s">Warhol’s father worked in a coal mine and the family lived in a house at 55 Beelen Street, but when Andy was three-years-old, his father lost his job and the family moved to an apartment at 3252 Dawson Street in the Oakland neighborhood of Pittsburgh. This is significant since at this time, his mother Julia, an expert at Rusyn crafts that included embroidery and egg decoration, supported them, in part, by fashioning flowers out of food cans and selling them to neighbors. Warhol acknowledged that this was the inspiration for his paintings of tin cans.</p>
      <p  class="wow fadeInRight" data-wow-delay=".4s"><img src="uploads/artists/Warhol/Warhol_TomatoSoup1964.jpg" alt=" Tomato Soup, 1964" border="20"></p>
      <div class="boldcap wow fadeInRight" data-wow-delay=".4s">Tomato Soup, 1964</div>
      <p class="wow fadeInLeft" data-wow-delay=".4s">Andy was considered a talented artist even in elementary school. During this time, his brother bought him a camera and showed him how to process film. In the third grade at age eight, Andy caught rheumatic fever, an affliction of the nervous system causing involuntary movements that is believed to be a complication of scarlet fever. The disease led to a blotchiness in pigmentation of his skin, which as a child made him somewhat of a hypochondriac. It also led him to develop a fear of hospitals and medical doctors. And because he was so often bedridden as a child, he became an outcast among his schoolmates and instead bonded strongly to his mother.</p>
      <p class="wow fadeInLeft" data-wow-delay=".4s">During the time he was confined to bed, Warhol made paper dolls, read comic books, listened to the radio and posted pictures of movie stars around his bed. Looking back, Warhol described this period of his sickness as very important in the development of his personality and in the forming of his skill-set and preferences.</p>
      <p class="wow fadeInLeft" data-wow-delay=".4s">The youngest Warhol showed an early artistic talent and studied commercial art when he recovered, taking art classes at the Carnegie Museum of Art that continued through high school. Though his father died when Andy was 13, his family managed to save enough money for him to go to college. He attended the School of Fine Arts at Carnegie Institute of Technology in Pittsburgh, now known as Carnegie Mellon University, studying design and commercial illustration.</p>
      <p  class="wow fadeInRight" data-wow-delay=".4s"><img src="uploads/artists/artists_l-z/warhol/warhol-eye.jpg" alt="Eye" border="20"></p>
      <div class="boldcap wow fadeInRight" data-wow-delay=".4s">Eye<br>
        1952, ink and tempera on paper, 15 Â¾ x 11 Â¾”<br>
        Ã•ffenliche Kunstsammlung, Basel, Switzerland</div>
      <p class="wow fadeInLeft" data-wow-delay=".4s">In his sophomore year of college, Warhol met Philip Pearlstein (later an important painter) with whom he moved to New York City with after graduation with a degree in pictorial design in 1949. On Warhol’s second day making the rounds of meeting publishers in New York, he got a contract from <em>Glamour</em> magazine to draw shoes. He began a successful career in magazine illustration and advertising, and became well-known mainly for his whimsical ink drawings of shoes in advertisements. They were done in a loose, blotted-ink style and figured in some of his earliest showings at the Bodley Gallery in New York.</p>
      <p  class="wow fadeInRight" data-wow-delay=".4s"><img src="uploads/artists/artists_l-z/warhol/warhol-shoe-and-leg.jpg" alt="Shoe and Leg" border="20"></p>
      <div class="boldcap wow fadeInRight" data-wow-delay=".4s">Shoe and Leg<br>
        1956, ballpoint pen, graphite, and ink on paper, 19 Â½ x 13 3/8â€³<br>
        The Andy Warhol Foundation for the Visual Arts, Pittsburgh, PA</div>
      <p class="wow fadeInLeft" data-wow-delay=".4s">During the 1950s, the music industry was expanding rapidly with the introduction of the vinyl record, Hi-Fi, and stereophonic recordings. RCA Records hired Warhol, along with another freelance artist named Sid Maurer, to design album covers and promotional materials. Warhol’s commercial illustration business was so good that he was able to hire an assistant, Nathan Gluck, to help him with preliminary drawings.</p>
      <p class="wow fadeInLeft" data-wow-delay=".4s">Soon after their initial success, Warhol and Pearlstein moved to their own studio. But when Andy’s mother visited her son in New York, she thought his studio was mice-ridden. So she moved to New York to take care of him and brought with her two cats named Sam and Hester. They had kittens, and Andy named all the kittens Sam. He illustrated a book of drawings of the cats, and his mother did the calligraphy. It was published in limited editions, each with a different color scheme, which he gave to art directors as gifts.</p>
      <p  class="wow fadeInRight" data-wow-delay=".4s"><img src="uploads/artists/artists_l-z/warhol/warhol-lavender-sam.jpg" alt="Lavender Sam, in 25 Cats Named Sam and One blue Pussy" border="20"></p>
      <div class="boldcap wow fadeInRight" data-wow-delay=".4s">Lavender Sam, in 25 Cats Named Sam and One blue Pussy<br>
        ca. 1955, 9 1/8 x 6â€³, offset prints hand-colored and lettered, one of an edition of 190</div>
      <p class="wow fadeInLeft" data-wow-delay=".4s">Beginning in the early 1950s, Warhol self-published several unbound portfolios of his work, with his first being his <em>25 Cats Name Sam and One Blue Pussy</em>, printed in 1954 by Seymour Berlin. He printed them on Arches brand watermarked paper using his blotted line technique for the lithographs. The original edition was limited to 190 numbered, hand colored copies using Dr. Martin’s ink washes.</p>
      <p class="wow fadeInLeft" data-wow-delay=".4s">Most of these were given by Warhol as gifts to clients and friends. Copy #4 has inscribed “Jerry” on the front cover, and was given to Geraldine Stutz, who at the time was with I. Miller Shoes. Today those copies are worth a lot of money. A later copy, for instance, that was once given to the head of Panache Press, an imprint of Random House, sold in May 2006 for $35,000.</p>
      <p class="wow fadeInLeft" data-wow-delay=".4s">As an advertisement illustrator in the 1950s, Warhol’s use of assistants to increase his productivity would remain a defining and controversial aspect of his working methods throughout his career. But in the 1960s, this collaboration was particularly true. One of the most important collaborators during this period was Gerard Malanga, who assisted the artist with producing silk screens, films, sculptures and other works at “The Factory,” the name given his art studios.</p>
      <p class="wow fadeInLeft" data-wow-delay=".4s">Other members of Warhol’s Factory crowd included Freddie Herko, Ondine, Ronald Tavel, Mary Woronov, Pietro Psaier, Billy Name and Brigid Berlin (from whom he apparently got the idea to tape record his phone conversations). During this decade, Warhol also groomed a retinue of Bohemian eccentrics upon whom he bestowed the designation “Superstars,” of whom included Edie Sedgwick, Viva and Ultra Violet. These people all participated in the Factory films, and some, like Brigid Berlin, remained friends with Warhol until his death.</p>
      <p  class="wow fadeInRight" data-wow-delay=".4s"><img src="uploads/artists/artists_l-z/warhol/edie-sedgewick-from-screen-tests.jpg" alt="Edie Sedgwick from Screen Tests" border="20"></p>
      <div class="boldcap wow fadeInRight" data-wow-delay=".4s">Edie Sedgwick from Screen Tests<br>
        1964, the Andy Warhol Museum, Pittsburgh, PA</div>
      <p class="wow fadeInLeft" data-wow-delay=".4s">Important figures in the New York underground art/cinema world, such as writer John Giorno and filmmaker Jack Smith, also appear in Warhol films of the 1960s. They reveal Warhol’s connections to a diverse range of artistic scenes during this period. By the end of the decade, he was himself a celebrity, appearing frequently in newspapers and magazines alongside Factory cohorts.</p>
      <p  class="wow fadeInRight" data-wow-delay=".4s"><img src="uploads/artists/Warhol/Warhol_AndyattheFactory.jpg" alt=" Andy at the Factory" border="20"></p>
      <div class="boldcap wow fadeInRight" data-wow-delay=".4s">Andy at the Factory</div>
      <p class="wow fadeInLeft" data-wow-delay=".4s">Over the years, Warhol’s “The Factory” changed locations throughout New York City. These locations and their dates of existence were:</p>
      <p class="wow fadeInLeft" data-wow-delay=".4s" align="justify">Factory: 1342 Lexington Avenue (The first Factory), 1950s to early ’60s</p>
      <p class="wow fadeInLeft" data-wow-delay=".4s" align="justify">Factory: 231 East 47th street, 1963-1967</p>
      <p class="wow fadeInLeft" data-wow-delay=".4s" align="justify">Factory: 33 Union Square, 1967-1973 (Decker Building)</p>
      <p class="wow fadeInLeft" data-wow-delay=".4s" align="justify">Factory: 860 Broadway, (near 33 Union Square) 1973</p>
      <p class="wow fadeInLeft" data-wow-delay=".4s" align="justify">Factory: 22 East 33rd Street, 1984-1987 (No longer exists)</p>
      <p class="wow fadeInLeft" data-wow-delay=".4s" align="justify">Last personal studio: 158 Madison Avenue, 1987</p>
      <p class="wow fadeInLeft" data-wow-delay=".4s">Business was booming for Andy Warhol in 1955, and he hired his Pittsburgh art-school friend Leonard Kessler to help him with illustration projects. He also got the help of another friend Ralph Pomeroy to write “Shoe Poems” for the ad he did for I. Miller. To finalize these ads, Andy gathered a group of friends at an ice-cream parlor and they colored the printed drawings with Dr. Martin’s dyes, while his mother again did the calligraphy. In 1957, he won the Art Director’s Club Medal for his fashion illustrations.</p>
      <p class="wow fadeInLeft" data-wow-delay=".4s">It was during the 1960s that much of Warhol’s mystique came into light. He sparked a revolution in art and his work quickly became controversial yet extremely popular. He founded “The Factory,” and he gathered around himself a wide range of artists, writers, musicians and underground celebrities.</p>
      <p class="wow fadeInLeft" data-wow-delay=".4s">Warhol switched to silkscreen prints, which he produced serially, seeking not only to make art out of mass-produced items but to mass produce the art itself. He declared that he wanted to be “a machine” and to minimize the role of his own hand in the production of his work. During this time, he began basing his paintings on comic strips and icons of famous American products like <em>Brillo</em>, <em>Campbell’s Soup Cans</em>, <em>Coca-Cola </em>and of dollar signs. As well, he made paintings of celebrities like Marilyn Monroe, Troy Donahue and Elizabeth Taylor.</p>
      <p  class="wow fadeInRight" data-wow-delay=".4s"><img src="uploads/artists/Warhol/Warhol_MarilynMonroe1962.jpg" alt=" Marilyn Monroe 1962" border="20"></p>
      <div class="boldcap wow fadeInRight" data-wow-delay=".4s">Marilyn Monroe, 1962</div>
      <p class="wow fadeInLeft" data-wow-delay=".4s">At the beginning of the 1960s, Warhol was a very successful commercial illustrator. His detailed and elegant drawings for I. Miller shoes were particularly popular. These illustrations consisted mainly of “blotted ink” drawings (or mono prints), a technique which he applied in much of his early art. Although many artists of this period worked in commercial art, most did so discreetly. But because Warhol was so successful as an illustrator, it seemed to undermine his efforts to be taken seriously as an artist.</p>
      <p  class="wow fadeInRight" data-wow-delay=".4s"><img src="uploads/artists/artists_l-z/warhol/andy-warhol-bonwit-teller-window-display.jpg" alt="Bonwit Teller Window display with five paintings by Andy Warhol, April 1961, New York" border="20"></p>
      <div class="boldcap wow fadeInRight" data-wow-delay=".4s">Bonwit Teller Window display with five paintings by Andy Warhol<br>
        April 1961, New York</div>
      <p class="wow fadeInLeft" data-wow-delay=".4s">In the early 1960s, Warhol tried to exhibit some of his drawings using his blotted-ink techniques in a gallery, only to be turned down. He began to rethink the relationship between his commercial work and the rest of his art. But instead of treating these things as opposites, he merged them and began to take commercial and popular culture more explicitly as his topic.</p>
      <p class="wow fadeInLeft" data-wow-delay=".4s">Pop Art was an experimental form that several artists were independently adopting. Some of these pioneers such as Roy Lichtenstein would later become synonymous with the movement. But Warhol would become famous as the “Pope of Pop.” He turned to this new style of making popular subjects a part of the artist’s palette.</p>
      <p class="wow fadeInLeft" data-wow-delay=".4s">Warhol’s early paintings show images taken from cartoons and advertisements, hand painted with paint drips. Those drips emulated the style of successful abstract expressionists, such as Robert Rauschenberg. Eventually, however, he pared his image vocabulary down to the icon itself of brand names, celebrities and dollar signs, and he removed all traces of the artist’s “hand” in the production of his paintings.</p>
      <p  class="wow fadeInRight" data-wow-delay=".4s"><img src="uploads/artists/artists_l-z/warhol/warhol-city.jpg" alt="Warhol, City" border="20"></p>
      <div class="boldcap wow fadeInRight" data-wow-delay=".4s">City<br>
        1962, pencil and gouache on paper, 73.7 x 58.4 “<br>
        Museum of Modern Art, New York</div>
      <p class="wow fadeInLeft" data-wow-delay=".4s">To Warhol, part of defining a niche was defining his subject matter. Because cartoons were already being used by Lichtenstein, typography by Jasper Johns, and so on, he wanted a distinguishing subject. His friends suggested he paint the things he loved the most. So in his signature way of taking things literally, for his first major solo exhibition at the well-respected art gallery at the Ferus Gallery in 1962 Los Angeles, he painted his famous <em>Campbell’s Soup Cans</em> from the Campbell Soup Company, which he claimed to have had for lunch most of his life. The 32 individual paintings were painted to look like they had come from a factory, not to look handmade. And since he loved celebrities, he painted them as well.</p>
      <p  class="wow fadeInRight" data-wow-delay=".4s"><img src="uploads/artists/Warhol/Warhol_LizaMinelli.jpg" alt=" Warhol, Liza Minelli" border="20"></p>
      <div class="boldcap wow fadeInRight" data-wow-delay=".4s">Liza Minelli</div>
      <p class="wow fadeInLeft" data-wow-delay=".4s">From these beginnings, Warhol developed his later style and subjects. He worked more and more on a signature style, which was to eliminate the handmade from the artistic process. He frequently used silk screening, and his drawings were traced from slide projections. He also went from being a painter to being a designer of paintings.</p>
      <p class="wow fadeInLeft" data-wow-delay=".4s">At the height of his fame as such a painter, he used several assistants to produce his silk-screen multiples, following his direction to make different versions and variations. He worked extensively with these silk-screenings, and his assistants were able to create images rapidly and repeatedly. Warhol liked to repeat images in rows, and did so not only in paintings but in film and photos.</p>
      <p  class="wow fadeInRight" data-wow-delay=".4s"><img src="uploads/artists/artists_l-z/warhol/paint-silk-screen-on-vanvas-warhol.jpg" alt=" No. 5 from Mao Tse-Tung1972" border="20"></p>
      <div class="boldcap wow fadeInRight" data-wow-delay=".4s">Paint silk-screened on canvas, 79 Â¾ x 143 Â¼”<br>
        Whitney Museum of American Art, New York</div>
      <p class="wow fadeInLeft" data-wow-delay=".4s">Warhol produced both comedic and serious works, and his subjects could be a soup can or an electric chair. He used the same silk-screen techniques that were reproduced serially, and often painted with bright colors whether he painted celebrities, everyday objects or images of suicide, car crashes and disasters. As part of a 1962-1963 series called “Death and Disaster,” such as “Red Car Crash,” “Purple Jumping Man” and “Orange Disaster,” he transformed personal tragedies into public spectacles, signaling the use of images of disaster in the then evolving media.</p>
      <p class="wow fadeInLeft" data-wow-delay=".4s">The unifying element in Warhol’s work has been coined a deadpan “Keatonesque-style” artistry and personal affectless. This was mirrored by his own demeanor, as he often played “dumb” to the media and refused to explain his work. The artist was famous for having said that all you need to know about him and his work is already there “on the surface.”</p>
      <p class="wow fadeInLeft" data-wow-delay=".4s">Warhol’s work as a Pop Artist has always had conceptual aspects. His series of do-it-yourself paintings and Rorschach blots are intended as comments on art and what art could be. His <em>Cow Wallpaper</em> (literally, wallpaper with a cow motif) and his oxidation paintings (canvases prepared with copper paint that was then oxidized with urine) are also noteworthy in this context. Equally noteworthy is the way these works and their means of production mirrored the atmosphere at Andy’s New York “Factory.”</p>
      <p  class="wow fadeInRight" data-wow-delay=".4s"><img src="uploads/artists/artists_l-z/warhol/warhol-do-it-yourself-narcissus.jpg" alt="Do It Yourself (Narcissus)" border="20"></p>
      <div class="boldcap wow fadeInRight" data-wow-delay=".4s">Do It Yourself (Narcissus)<br>
        1962, graphite and colored crayon on paper, 23 Â¾ x 18â€³<br>
        öffentliche Kunstsammlung Basel, Switzerland</div>
      <p class="wow fadeInLeft" data-wow-delay=".4s">Biographer Bob Colacello provides some details on Andy’s “piss paintings,” stating, “Victor… was Andy’s ghost pisser on the Oxidations. He would come to the Factory to urinate on canvases that had already been primed with copper-based paint by Andy or Ronnie Cutrone, who was a second ghost pisser, much appreciated by Andy, who said that the vitamin B that Ronnie took made a prettier color when the acid in the urine turned the copper green. Did Andy ever use his own urine? My diary shows that when he first began the series in December 1977 he did. And there were many others-boys who’d come to lunch and drink too much wine and find it funny or even flattering to be asked to help Andy ‘paint.’ Andy always had a little extra bounce in his walk as he led them to his studio.”</p>
      <p  class="wow fadeInRight" data-wow-delay=".4s"><img src="uploads/artists/Warhol/Warhol_PissAndSex.jpg" alt=" Piss and Sex" border="20"></p>
      <div class="boldcap wow fadeInRight" data-wow-delay=".4s">Piss and Sex</div>
      <p class="wow fadeInLeft" data-wow-delay=".4s">By the late 1960s, Warhol was doing many portraits of celebrities. He also founded the fashion magazine <em>Interview</em> in 1968, which is still published today. It was created as a stage for celebrities he endorsed and a business staffed by his friends. The loopy title script on the cover is thought to be either his own handwriting or that of his mother, Julia, who would often do text work for his early commercial pieces.</p>
      <p  class="wow fadeInRight" data-wow-delay=".4s"><img src="uploads/artists/Warhol/Warhol_InterviewMagazine.jpg" alt=" Interview Magazine" border="20" width="auto"></p>
      <div class="boldcap wow fadeInRight" data-wow-delay=".4s">Interview Magazine</div>
      <p class="wow fadeInLeft" data-wow-delay=".4s">During this time, Warhol worked across a wide range of other media, such as photography, drawing and sculpture. In addition, he was a highly prolific filmmaker. Between 1963 and 1968, he made more than 60 films. One of his most famous films, <em>Sleep</em>, monitors poet John Giorno sleeping for six hours. Another, <em>Empire</em>, consists of eight hours of footage of the Empire State Building in New York City at dusk. The 45-minute film <em>Eat</em> consists of a man eating a mushroom for 45 minutes.</p>
      <p class="wow fadeInLeft" data-wow-delay=".4s">In 1964, Warhol produced and directed <em>Batman Dracula</em>, without the permission of DC Comics. It was screened only at his art exhibits. A fan of the Batman series, Warhol’s movie was a homage to the series and is considered the first appearance of a blatantly campy Batman. The film was thought to have been lost until recently, when footage from the picture were shown at some length in a 2006 documentary entitled, “Jack Smith and the Destruction of Atlantis.”</p>
      <p class="wow fadeInLeft" data-wow-delay=".4s">Warhol’s 1965 film called <em>Vinyl</em> is an adaptation of Anthony Burgess’ popular dystopian novel “A Clockwork Orange.” Others record improvised encounters between Factory regulars such as Brigid Berlin, Viva, Edie Sedgwick, Candy Darling, Holly Woodlawn, Ondine, Nico and Jackie Curtis. Legendary underground artist Jack Smith appears in the film Camp.</p>
      <p class="wow fadeInLeft" data-wow-delay=".4s">His most popular and critically successful film was the 1966 “Chelsea Girls.” The film was highly innovative in that it consisted of two 16mm films being projected simultaneously, with two different stories being shown in tandem. From the projection booth, the sound would be raised for one film to elucidate one story, while it was lowered for the other. The multiplication of images evoked Warhol’s seminal silk-screen works of the early 1960s. The influence of the film’s split-screen, multi-narrative style could be felt in such modern work as Mike Figgis’ Timecode and, however indirectly, the early seasons of 24.</p>
      <p class="wow fadeInLeft" data-wow-delay=".4s">Other important films include <em>Bike Boy</em>, <em>My Hustler</em> and <em>Lonesome Cowboys</em>, with the latter being a raunchy pseudo-western. These and other titles document gay underground and camp culture, and they continue to feature prominently in scholarship about sexuality and art. Some include Mathew Tinkom’s <em>Working Like a Homosexual</em> (Duke University Press, 2002) or Juan Suarez’s <em>Bike Boys</em>, <em>Drag Queens</em> and <em>Superstars</em> (Indiana University Press, 1996).</p>
      <p class="wow fadeInLeft" data-wow-delay=".4s"><em>Blue Movie</em>, a film in which Warhol superstar Viva makes love and fools around in bed with a man for 33 minutes, was Warhol’s last film as a director. The film at the time was scandalous for its frank approach to a sexual encounter. For many years, Viva refused to allow it to be screened, but it was publicly screened in New York in 2005 for the first time in over 30 years.</p>
      <p class="wow fadeInLeft" data-wow-delay=".4s">It was after his June 3, 1968, shooting that Warhol became reclusive and relinquished his personal involvement in film making. His acolyte and assistant director, Paul Morrissey, took over the film making chores for “The Factory,” steering Warhol-branded cinema towards more mainstream, narrative-based, B-movie exploitation fare. All of these films, including Andy Warhol’s <em>Dracula</em> and <em>Frankenstein</em>, were far more mainstream than anything Warhol attempted as a director. These latter Warhol films starred Joe Dallesandro, who was more of a Morrissey star than a true Warhol superstar.</p>
      <p class="wow fadeInLeft" data-wow-delay=".4s">In order to facilitate the success of these Warhol-branded, Morrissey-directed movies in the marketplace, all of Warhol’s earlier avant-garde films were removed from distribution and exhibition by 1972.</p>
      <p class="wow fadeInLeft" data-wow-delay=".4s">Another film, Andy Warhol’s <em>Bad</em>, made significant impact as a “Warhol” film yet was directed by Jed Johnson. <em>Bad</em> starred the infamous Carroll Baker, Susan Blond and a young Perry King.</p>
      <p class="wow fadeInLeft" data-wow-delay=".4s">Also in the mid 1960s, Warhol helped produce multi-media events using the rock group <em>The Velvet Underground</em>. He adopted the band, making them a crucial element of the “Exploding Plastic Inevitable,” a multimedia performance art show. Warhol and Paul Morrissey acted as the band’s managers, introducing them to Nico, who would perform with the band at Warhol’s request.</p>
      <p class="wow fadeInLeft" data-wow-delay=".4s">In 1966, Warhol produced their first album called <em>The Velvet Underground and Nico</em>, as well as providing its album art. His actual participation in the album’s production amounted to simply paying for the studio time. After the band’s first album, Warhol and band leader Lou Reed started to disagree about the direction the band should take, and the contact between them faded.</p>
      <p  class="wow fadeInRight" data-wow-delay=".4s"><img src="uploads/artists/Warhol/VelvetUndergroundBanana.jpg" alt=" Album Cover for The Velvet Underground and Nico, 1967" border="20"></p>
      <div class="boldcap wow fadeInRight" data-wow-delay=".4s">Album Cover for The Velvet Underground and Nico, 1967</div>
      <p class="wow fadeInLeft" data-wow-delay=".4s">In the mid- to late-1960s, Warhol’s work revolved around American Pop (Popular) Culture. He painted dollar bills, celebrities, brand-name products and images from newspaper clippings. The latter were iconic images from headline stories of the decade, such as photographs of mushroom clouds and police dogs attacking civil rights protesters.</p>
      <p  class="wow fadeInRight" data-wow-delay=".4s"><img src="uploads/artists/Warhol/dollarSign.jpg" alt=" Dollar Signs 1982" border="20"></p>
      <div class="boldcap wow fadeInRight" data-wow-delay=".4s">Dollar Signs, 1982</div>
      <p class="wow fadeInLeft" data-wow-delay=".4s">Warhol’s subjects were instantly recognizable and often had mass appeal, which was of great interest to the artist. His following comments on Coke reflect this, and also express his affection for popular culture and is evidence of his ambiguous perspective that cuts across nearly all of the artist’s statements about his own work:</p>
      <p class="wow fadeInLeft" data-wow-delay=".4s">“What’s great about this country is that America started the tradition where the richest consumers buy essentially the same things as the poorest. You can be watching TV and see <em>Coca Cola</em>, and you know that the President drinks <em>Coca Cola</em>, Liz Taylor drinks <em>Coca Cola</em>, and just think, you can drink <em>Coca Cola</em>, too. A coke is a coke and no amount of money can get you a better coke than the one the bum on the corner is drinking. All the cokes are the same and all the cokes are good. Liz Taylor knows it, the President knows it, the bum knows it, and you know it.” (From The Philosophy of Andy Warhol: From A to B and Back Again, 1975.)</p>
      <p  class="wow fadeInRight" data-wow-delay=".4s"><img src="uploads/artists/Warhol/Warhol_CocaColaBottles1962.jpg" alt=" Coca-Cola Bottles 1962" border="20"></p>
      <div class="boldcap wow fadeInRight" data-wow-delay=".4s">Coca-Cola Bottles, 1962</div>
      <p class="wow fadeInLeft" data-wow-delay=".4s">New York’s Museum of Modern Art hosted a Symposium on Pop Art in December 1962, during which artists like Warhol were attacked for “capitulating” to consumerism. Critics were scandalized by Warhol’s open embrace of market culture. This symposium set the tone for Warhol’s reception throughout the decade, and it became more and more clear that there had been a profound change in the culture of the art world and that Warhol was at the center of that shift.</p>
      <p class="wow fadeInLeft" data-wow-delay=".4s">A pivotal event was the 1964 exhibit “The American Supermarket,” which was a show held in Paul Bianchini’s Upper East Side gallery. The show was presented as a typical small supermarket environment, except that everything in it-the produce, canned goods, meat and posters on the wall-were created by six prominent Pop Artists of the time. They included the controversial and like-minded Billy Apple, Mary Inman and Robert Watts. Warhol’s painting of a <em>Can of Campbell’s Soup</em> cost $1,500, while each autographed can sold for $6. The exhibit was one of the first mass events that directly confronted the general public with both Pop Art and the perennial question of what is art.</p>
      <p  class="wow fadeInRight" data-wow-delay=".4s"><img src="uploads/artists/Warhol/Warhol_MickeyMouse.jpg" alt=" Warhol, Mickey Mouse" border="20"></p>
      <div class="boldcap wow fadeInRight" data-wow-delay=".4s">Mickey Mouse</div>
      <p class="wow fadeInLeft" data-wow-delay=".4s">Warhol’s first European exhibit was in Stockholm in 1968. He also participated in Documentary 8 in Kassel that year. In the spring of 1968, former Factory habitant Valerie Solanos had written a script she wanted Warhol to consider. On June 3, 1968, Solanas shot and nearly killed Warhol and Art Critic/Curator Mario Amaya at the Factory. Warhol was hospitalized for two months. Before the shooting, Valerie Solanas had been a marginal figure in the Factory scene. She founded a group called S.C.U.M. (Society For Cutting Up Men) and authored the S.C.U.M. Manifesto, a separatist feminist attack on patriarchy. Solanas appears in the 1968 Warhol film, “I, A Man.” Earlier on the day of the attack, Solanas had been turned away from the Factory after asking for the return of her script she had given to Warhol. The script had apparently been misplaced.</p>
      <p class="wow fadeInLeft" data-wow-delay=".4s">Mario Amaya received only minor injuries and was released from the hospital later the same day. Warhol however was seriously wounded by the attack and barely survived after doctors opened his chest and massaged his heart to help stimulate its movement again. He suffered physical effects for the rest of his life, and the shooting also had a profound effect on Warhol’s life and art thereafter.</p>
      <p class="wow fadeInLeft" data-wow-delay=".4s">Solanas was arrested the day after the assault. By way of explanation, she said that “He had too much control over my life.” After the shooting, the Factory scene became much more tightly controlled, and for many, this event brought the “Factory 60s” to an end.</p>
      <p  class="wow fadeInRight" data-wow-delay=".4s"><img src="uploads/artists/artists_l-z/warhol/warhol-female-faces.jpg" alt="Female Faces" border="20"></p>
      <div class="boldcap wow fadeInRight" data-wow-delay=".4s">Female Faces<br>
        Ink and gouache on paper, 1960, 23 1/8 x 13 1/2 “<br>
        The Andy Warhol Foundation for the Visual Arts</div>
      <p class="wow fadeInLeft" data-wow-delay=".4s">In the late 1960s, Warhol had so many invitations to speak around the country, he became tired of them. He hired impersonators to appear instead, mostly at colleges in the West and Midwest. After nearly a year, the ruse was discovered when college journalists compared their photos of Andy Warhol with those appearing in the New York press. The actor Allen Midgette was the best known of those paid, and later wrote a book about Andy Warhol imitators.</p>
      <p class="wow fadeInLeft" data-wow-delay=".4s">After his brush with death in 1968, Warhol shunned the company of drug addicts, petty criminals, transvestites and other marginal characters who had previously dominated his entourage. He joined the international jet set and was surrounded by the rich and famous, whose portraits he painted in the last 20 years of his life.</p>
      <p  class="wow fadeInRight" data-wow-delay=".4s"><img src="uploads/artists/artists_l-z/warhol/warhol-elvis.jpg" alt="Warhol, Elvis" border="20"></p>
      <div class="boldcap wow fadeInRight" data-wow-delay=".4s">Elvis<br>
        1963, 82 x 36â€³<br>
        Australian National Gallery, Canberra</div>
      <p class="wow fadeInLeft" data-wow-delay=".4s">Compared to the success and scandal of Warhol’s work in the ’60s, the 1970s would prove a much quieter decade. This period, however, saw Warhol becoming more entrepreneurial. According to Bob Colacello, Warhol devoted much of his time to rounding up new, rich patrons for portrait commissions, including Mick Jagger, Liza Minnelli, John Lennon, Diana Ross, Brigitte Bardot and Michael Jackson.</p>
      <p class="wow fadeInLeft" data-wow-delay=".4s">Warhol used to socialize at <em>Serendipity 3</em> and, later at the infamous 1970s <em>Studio 54</em> and other night spots in New York City. He was generally regarded as quiet, shy and a meticulous observer. Art critic Robert Hughes called him “the white mole of Union Square.”</p>
      <p  class="wow fadeInRight" data-wow-delay=".4s"><img src="uploads/artists/Warhol/Warhol_PaulJenkins1979.jpg" alt=" Paul Jenkins 1979" border="20"></p>
      <div class="boldcap wow fadeInRight" data-wow-delay=".4s">Paul Jenkins, 1979</div>
      <p class="wow fadeInLeft" data-wow-delay=".4s">Warhol’s famous portrait of Chinese Communist Leader Mao Zedong was created in 1973. His Chairman Mao series of silk-screens had major shows of portraits in 1974 in Zurich and from 1979 to 1980 at the Whitney Museum of American Art in New York.</p>
      <p class="wow fadeInLeft" data-wow-delay=".4s">In this time, he also published The Philosophy of Andy Warhol (1975). In this book, he presents his ideas on the nature of art, “Making money is art, and working is art and good business is the best art.”</p>
      <p  class="wow fadeInRight" data-wow-delay=".4s"><img src="uploads/artists/Warhol/Warhol_No5.jpg" alt=" No. 5 from Mao Tse-Tung1972" border="20"></p>
      <div class="boldcap wow fadeInRight" data-wow-delay=".4s">No. 5 from Mao Tse-Tung, 1972</div>
      <p class="wow fadeInLeft" data-wow-delay=".4s">Warhol worked much with musicians in the 1970s, designing many album covers for various artists. This started actually in 1964 with the photographic cover of John Wallowitch’s debut album, <em>This Is John Wallowitch!!!</em> But in the ’70s, this intensified. He designed the cover art for The Rolling Stones albums <em>Sticky Fingers</em> in 1971 and <em>Love You Live</em> in 1977. In 1975, Warhol was commissioned to do several portraits of the band’s front-man Mick Jagger.</p>
      <p  class="wow fadeInRight" data-wow-delay=".4s"><img src="uploads/artists/Warhol/Warhol_MickJagger1975.jpg" alt=" Mick Jagger, 1975" border="20"></p>
      <div class="boldcap wow fadeInRight" data-wow-delay=".4s">Mick Jagger, 1975</div>
      <p class="wow fadeInLeft" data-wow-delay=".4s">Warhol was also friendly with many musicians, including Bob Dylan, Deborah Harry and John Lennon. He designed the cover to Lennon’s 1986 posthumously released <em>Menlove Ave</em>. Warhol also appeared as a bartender in The Cars’ music video for their single “Hello Again” and Curiosity Killed The Cat’s video for their “Misfit” single. Both videos, and others, were produced by Warhol’s video production company.</p>
      <p class="wow fadeInLeft" data-wow-delay=".4s">Warhol strongly influenced the New Wave/punk rock band Devo as well as David Bowie. Bowie recorded a song called “Andy Warhol” for his 1971 album <em>Hunky Dory</em>. Lou Reed wrote the song “Andy’s Chest,” which is about Valerie Solanas, the woman who shot Warhol. He recorded it with <em>The Velvet Underground,</em> but this version wasn’t officially released until the album appeared in 1985. He recorded a new version for his 1972 solo album <em>Transformer</em>, produced by Bowie and Mick Ronson.</p>
      <p class="wow fadeInLeft" data-wow-delay=".4s">Warhol had a reemergence of critical and financial success in the 1980s, partially due to his affiliation and friendships with a number of prolific younger artists who were dominating the “bull-market” of ’80s New York art. They included Jean-Michel Basquiat, Julian Schnabel, David Salle and the so-called Neo-Expressionists Francesco Clemente and Enzo Cucchi. As well, members of the Transavanguardia movement, which had become influential.</p>
      <p  class="wow fadeInRight" data-wow-delay=".4s"><img src="uploads/artists/Warhol/Warhol_DiamondDustShoes1980.jpg" alt=" Diamond Dust Shoes 1980" border="20"></p>
      <div class="boldcap wow fadeInRight" data-wow-delay=".4s">Diamond Dust Shoes, 1980</div>
      <p class="wow fadeInLeft" data-wow-delay=".4s">Warhol also had an appreciation for Hollywood glamour. He once said, “I love Los Angeles. I love Hollywood. They’re so beautiful. Everything’s plastic, but I love plastic. I want to be plastic.”</p>
      <p class="wow fadeInLeft" data-wow-delay=".4s">The question of how his sexuality influenced Warhol’s work and shaped his relationship to the art world is a major subject of scholarship on the artist and is an issue that Warhol himself addressed in interviews, in conversation and in his publications, such as <em>Popism: The Warhol Sixties</em>. Many people think of Warhol as “asexual” and a “voyeur,” but these notions have been debunked by biographers, such as Victor Bockris, as explored by other members of the factory scene such as Bob Colacello in his book <em>Holy Terror: Andy Warhol Close Up</em>, and by scholars like Richard Meyer in his book <em>Outlaw Representation</em>.</p>
      <p class="wow fadeInLeft" data-wow-delay=".4s">Throughout his career, Warhol produced erotic photography and drawings of male nudes. Many of his famous works, such as portraits of Liza Minnelli, Judy Garland, Elizabeth Taylor and films like <em>Blow Job</em>, <em>My Hustler</em> and <em>Lonesome Cowboys</em> draw from gay underground culture and/or openly explore the complexity of sexuality and desire. Many of his films premiered in gay-porn theaters.</p>
      <p class="wow fadeInLeft" data-wow-delay=".4s">That said, some stories about Warhol’s development as an artist revolved around the obstacle his sexuality initially presented as he tried to launch his career. The first works that he submitted to a gallery in the pursuit of a career as an artist were homoerotic drawings of male nudes. They were rejected for being too openly gay.</p>
      <p class="wow fadeInLeft" data-wow-delay=".4s">In <em>Popism</em>, furthermore, the artist recalls a conversation with filmmaker Emile de Antonio about the difficulty Warhol had being accepted socially by the then more famous, but closeted, gay artists Jasper Johns and Robert Rauschenberg. De Antonio explained that Warhol was “too swish and that upsets them.” In response to this, Warhol writes, “There was nothing I could say to that. It was all too true. So I decided I just wasn’t going to care because those were all the things that I didn’t want to change anyway, that I didn’t think I ‘should’ want to change… Other people could change their attitudes but not me.”</p>
      <p class="wow fadeInLeft" data-wow-delay=".4s">In exploring Warhol’s biography, many turn to the period of the late 1950s and early 1960s as a key moment in the development of his persona. Some have suggested that his frequent refusal to comment on his work and to speak about himself or even the evolution of his Pop style can be traced to the years when Warhol was first dismissed by the inner circles of the New York art world. He often confined himself in interviews to responses like “Um, No” and “Um, Yes” and often allowed others to speak for him.</p>
      <p  class="wow fadeInRight" data-wow-delay=".4s"><img src="uploads/artists/Warhol/Warhol_Knives1981.jpg" alt=" Knives, Acrylic and Silkscreen Ink on Canvas, 1981-1982" border="20"></p>
      <div class="boldcap wow fadeInRight" data-wow-delay=".4s">Knives, Acrylic and Silkscreen Ink on Canvas, 1981-1982</div>
      <p class="wow fadeInLeft" data-wow-delay=".4s">Warhol was a practicing Byzantine Rite Catholic. He regularly volunteered at homeless shelters in New York, particularly during the busier times of the year and described himself as a religious person. Many of his later works contain almost hidden religious themes or subjects, and a body of religious-themed works was found posthumously in his estate. Warhol also regularly attended Mass during his life, and the priest at Warhol’s church, Saint Vincent’s, said that the artist went there almost daily.” His art is noticeably influenced by the eastern Christian iconographic tradition, which was so evident in his places of worship.</p>
      <p class="wow fadeInLeft" data-wow-delay=".4s">His later oeuvre was also heavily influenced by the Old Masters, particularly religious works like Leonardo da Vinci’s <em>The Last Supper</em>. In January 1987, Warhol traveled to Milan for the opening of his exhibit of silk-screens based on <em>The Last Supper</em>.</p>
      <p  class="wow fadeInRight" data-wow-delay=".4s"><img src="uploads/artists/artists_l-z/warhol/warhol-the-last-supper-silkscreen.jpg" alt="Warhol, Last Supper" border="20"></p>
      <div class="boldcap wow fadeInRight" data-wow-delay=".4s">Last Supper<br>
        1986, acrylic and silkscreen ink on canvas, 78 x 306.2 “<br>
        The Andy Warhol Museum, Pittsburgh, PA</div>
      <p class="wow fadeInLeft" data-wow-delay=".4s">Warhol’s brother described the artist as “really religious, but he didn’t want people to know about that because [it was] private.” Friend John Richardson depicted him as devout, stating “To my certain knowledge, he was responsible for at least one conversion. He took considerable pride in financing his nephew’s studies for the priesthood.”</p>
      <p class="wow fadeInLeft" data-wow-delay=".4s">In the early 1980s, Warhol made a number of works for children, exhibited in Zurich. In 1983 he finished his series <em>Endangered Species</em>. At the same time, the Campbell Soup Company engaged him to make paintings of some of their newer products.</p>
      <p  class="wow fadeInRight" data-wow-delay=".4s"><img src="uploads/artists/artists_l-z/warhol/warhol-cambells-soup-can.jpg" alt="Warhol, Big Campbell's Soup Can" border="20"></p>
      <div class="boldcap wow fadeInRight" data-wow-delay=".4s">Big Campbell’s Soup Can<br>
        19 c, 1962, acrylic and pencil on canvas, 72 x 54 Â½”<br>
        The Menil Collection, Houston, TX, trademarks Campbell Soup Company, Camden, NJ</div>
      <p class="wow fadeInLeft" data-wow-delay=".4s">In February 1987, Warhol was having was having recurring gallbladder problems. But because of his experience being sick as a child, he was afraid to enter hospitals or go to doctors to see why. However, when he became too sick to go to work for the first time in nearly a decade, he had it checked out and found out he needed a routine gallbladder operation. He checked into New York Hospital.</p>
      <p class="wow fadeInLeft" data-wow-delay=".4s">Warhol had been making a good recovery after surgery, but had a sudden heart attack shortly thereafter and died in New York City at 6:32 am on February 22, 1987. According to news reports, the hospital staff had failed to adequately monitor his condition and overloaded him with fluids after his operation, causing him to suffer from a fatal case of water intoxication that caused the subsequent heart attack.</p>
      <p class="wow fadeInLeft" data-wow-delay=".4s">Warhol was 58-years-old when he died. He left nearly all of his estate to <em>The Andy Warhol Foundation for the Visual Arts</em>, making his long-time business manager its director. He left the rest to his family.</p>
      <p class="wow fadeInLeft" data-wow-delay=".4s">Warhol’s lawyers sued New York Hospital for their negligence on behalf of The Foundation and received $3 million, much of which it gave to the Warhol family in return for their agreement not to ask for any more money. The estate went to the New York probate court, and the total value was estimated to be worth $510 million. Because Warhol designated the lawyers for the estate to be paid a fixed percentage of the estate’s value, and the same for certain charities, The Foundation hired a renowned art gallery owner to testify that Warhol’s art was likely to decline in value so the estate would be valued at considerably less.</p>
      <p class="wow fadeInLeft" data-wow-delay=".4s">Warhol’s body was taken back to Pittsburgh by his brothers for burial. The wake was at the Thomas P. Kunsak Funeral Home and was an open-coffin ceremony. Warhol was laid in a solid-bronze casket with gold-plated rails and white upholstery. He wore a black-cashmere suit, a paisley tie, a platinum wig and a pair of sunglasses. In his hands were a small prayer book and a red rose.</p>
      <p class="wow fadeInLeft" data-wow-delay=".4s">His funeral liturgy was held at the Holy Ghost Byzantine Catholic Church on Pittsburgh’s North Side. The eulogy was given by Monsignor Peter Tay and fellow artist Yoko Ono. The coffin was covered with white roses and asparagus ferns. After the liturgy, the coffin was driven to St. John the Baptist Byzantine Catholic Cemetery in Bethel Park, a south suburb of Pittsburgh. At the grave, the priest said a brief prayer and sprinkled holy water on the casket. Before the coffin was lowered, Paige Powell dropped a copy of <em>Interview</em> magazine, an <em>Interview</em> t-shirt and a bottle of the Estee Lauder perfume “Beautiful” into the grave. Warhol was buried next to his mother and father. Weeks later on April 1, 1987, a memorial service was held in Manhattan for Warhol at St. Patrick’s Cathedral, NY.</p>
      <p  class="wow fadeInRight" data-wow-delay=".4s"><img src="uploads/artists/Warhol/Warhol_SelfPortrait1986.jpg" alt=" Picture of Andy Warhol" border="20"></p>
      <div class="boldcap wow fadeInRight" data-wow-delay=".4s">Portrait of the Artist</div>
      <p class="wow fadeInLeft" data-wow-delay=".4s">Warhol had so many possessions that it took Sotheby’s nine days to auction his estate after his death. The auction yielded about $20 million, and The foundation also sold Warhol’s real estate in New York City, Montauk and Aspen, taking in close to $100 million more. The total estate was worth considerably more than what it was estimated to be worth, in no small part due to shrewd investments over the years. Today, <em>The Andy Warhol Foundation for the Visual Arts</em> awards grants and runs the Andy Warhol Museum in Pittsburgh.</p>
      <p class="wow fadeInLeft" data-wow-delay=".4s">On the 20th anniversary of his death, The Gershwin Hotel in New York City held a week long series of events commemorating Warhol’s art and his “superstars.” There was an award ceremony, a fashion show and a performance by Blondie at the closing party. At the same time, The Carrozzini von Buhler Gallery in New York City held an exhibit titled <em>Andy Warhol: In His Wake</em>. The exhibit featured the art of Warhol’s superstars Ultra Violet, Billy Name, Taylor Mead and Ivy Nicholson, as well as art by a younger generation of artists who have been inspired by Warhol.</p>
      <p class="wow fadeInLeft" data-wow-delay=".4s">One interactive sculpture in the exhibit, <em>The Great Warhola</em>, by Cynthia von Buhler, depicted Warhol as an arcade fortune-telling machine. The gallery was transformed to look like Warhol’s silver factory. <em>Factory Girl</em>, a film about the life of Edie Sedgwick starring Sienna Miller and Hayden Christensen was also released one week before the anniversary of his death.</p>
      <p  class="wow fadeInRight" data-wow-delay=".4s"><img src="uploads/artists/artists_l-z/warhol/warhol-ladies-and-gentlemen.jpg" alt="Ladies and Gentlemen" border="20"></p>
      <div class="boldcap wow fadeInRight" data-wow-delay=".4s">Ladies and Gentlemen<br>
        1975<br>
        The Andy Warhol Museum, Pittsburgh, PA</div>
      <p class="wow fadeInLeft" data-wow-delay=".4s">Two museums have been dedicated to Warhol. The Andy Warhol Museum, which is one of the Carnegie Museums of Pittsburgh located at 117 Sandusky Street. It’s the largest American art museum dedicated to a single artist, holding more than 12,000 works by the Warhol himself. The other museum is the Andy Warhol Museum of Modern Art, established in 1991 by Andy’s brother John Warhola, the Slovak Ministry of Culture and the Warhol Foundation in New York. It is located in the small town of Medzilaborce, Slovakia, 15 kilometers away from where his parents were born. The museum houses several originals donated by the Andy Warhol Foundation in New York and also personal items donated by Warhol’s relatives. An exhibit dedicated to the works of Andy Warhol is on display at the World of Coke in Atlanta, Georgia.</p>
      <p  class="wow fadeInRight" data-wow-delay=".4s"><img src="uploads/artists/Warhol/Warhol_Lamentation388MarthaGraham.jpg" alt=" Lamentation #388 (Martha Graham)" border="20"></p>
      <div class="boldcap wow fadeInRight" data-wow-delay=".4s">Lamentation #388 (Martha Graham)</div>
      <p class="wow fadeInLeft" data-wow-delay=".4s">As stated, although Andy Warhol is mostly known for his paintings and films, he has authored works in many different media. Some include:</p>
      <p class="wow fadeInLeft" data-wow-delay=".4s" align="justify"><strong>Drawing</strong>: Warhol started his career drawing commercial illustrations in “blotted-ink” style for warehouses and magazines. Most well-known are his pictures of shoes. Some of his drawings were published in little booklets, like “Yum, Yum, Yum” (about food), “Ho, Ho, Ho” (about Christmas) and (of course) “Shoes, Shoes, Shoes.” His most artistically acclaimed book of drawings is probably “The Gold Book,” compiled of sensitive and personal drawings of young men. It’s dubbed “The Gold Book” is because of the gold leaf that decorates the pages.</p>
      <p class="wow fadeInLeft" data-wow-delay=".4s" align="justify"><strong>Sculpture</strong>: Warhol’s most famous sculpture is probably his “Brillo Boxes,” which are silk-screened bronze replicas of Brillo soap boxes. Other famous works include the “Silver Clouds,” helium filled, silver Mylar, pillow-shaped balloons. A “Silver Cloud” was included in the traveling exhibition “Air Art” (1968-1969) produced by Willoughby Sharp.</p>
      <p class="wow fadeInLeft" data-wow-delay=".4s" align="justify"><strong>Audio</strong>: At one point, Warhol carried a portable recorder with him wherever he went, taping everything everybody said and did. He referred to this device as his “wife.” Some of these tapes were the basis for his literary work. Another audio work of Warhol’s was his “Invisible Sculpture,” a presentation in which burglar alarms would go off when entering the room. Warhol’s cooperation with the musicians of <em>The Velvet Underground</em> was driven by an expressed desire to become a music producer.</p>
      <p class="wow fadeInLeft" data-wow-delay=".4s" align="justify"><strong>Time capsules</strong>: Throughout his life, Warhol saved many of his correspondences, articles about himself and those which fascinated him, and numerous other items from food to gay porn. Several of these items were boxed up and progressively numbered. They eventually totaled in the dozens. Today the Warhol Museum houses them and is in the process of opening and sorting them. As of 2008, there remain boxes that, while cataloged, have not been re-opened since their original sealing. (See external links below for more info).</p>
      <p class="wow fadeInLeft" data-wow-delay=".4s" align="justify"><strong>Television</strong>: Andy Warhol dreamed of a television show that he wanted to call “The Nothing Special” that would be a special about his favorite subject: Nothing. Later in his career he created two cable television shows called “Andy Warhol’s TV” in 1982 and “Andy Warhol’s Fifteen Minutes,” based on his famous “fifteen-minutes-of-fame” quotation for MTV in 1986. Besides his own shows, he regularly made guest appearances on other programs, including “The Love Boat.” Warhol also produced a TV commercial for Schrafft’s Restaurants in New York City for an ice-cream dessert appropriately titled the “Underground Sundae”.</p>
      <p class="wow fadeInLeft" data-wow-delay=".4s" align="justify"><strong>Fashion</strong>: Warhol is quoted for having said: “I’d rather buy a dress and put it up on the wall than put a painting, wouldn’t you?” One of his most well-known Superstars, Edie Sedgwick, aspired to be a fashion designer, and his good friend Halston was a famous one. Warhol’s work in fashion includes silk-screened dresses, a short sub-career as a catwalk model and books on fashion as well as paintings with fashion as a subject.</p>
      <p class="wow fadeInLeft" data-wow-delay=".4s" align="justify"><strong>Performance Art</strong>: Warhol and his friends staged happenings, which are theatrical multimedia presentations during parties that contained music, film, slide projections and Gerard Malanga in an S&amp;M outfit cracking a whip. <em>The Exploding Plastic Inevitable</em> is the culmination of this area of his work.</p>
      <p class="wow fadeInLeft" data-wow-delay=".4s" align="justify"><strong>Computer</strong>: Warhol used Amiga computers to generate digital art.</p>
      <p class="wow fadeInLeft" data-wow-delay=".4s">Warhol was also a fan of “Art Business” and “Business Art.” He wrote about this interest in <em>The Philosophy of Andy Warhol from A to B and Back Again</em>. Thinking about art as business was a radical new stance, since artists traditionally positioned themselves against commercialism. Warhol and other Pop Artists helped redefine the artist’s position as professional, commercial and popular. He did this using methods, imagery and talents that were, or at least seemed to be, available to everyone. In this respect, Pop Art has contributed to a philosophical and practical incorporation of art into popular culture and society, and art offered to us as a product of that society.</p>
      <p class="wow fadeInLeft" data-wow-delay=".4s">As a testament to his success as an artist, Warhol had solo exhibitions nearly every year of his life, and many have been held after his death in attribution to his work. His work was exhibited throughout the world. Some of the major Warhol art exhibitions were:</p>
      <ul class="wow fadeInLeft" data-wow-delay=".4s">
        <li>1952 Group show, Hugo Gallery, New York</li>
        <li>1954 Group show, Loft Gallery, New York</li>
        <li>1956 Group show, Museum of Modern Art</li>
        <li>1959 Group show, Bodley Gallery, New York</li>
        <li>1961 Bonwit Teller window, New York</li>
        <li>1962 Ferus Gallery, Los Angeles, CA</li>
        <li>1963 Ferus Gallery, Los Angeles, CA; Ileanna Sonnabend, Paris, France</li>
        <li>1964 New York World’s Fair Stable Gallery, New York</li>
        <li>1966 Leo Castelli, New York</li>
        <li>1967 Galerie Rudolf Zwirner, Köln, Germany; Ileanna Sonnabend, Paris, France</li>
        <li>1968 Stedlijk Museum, Amsterdam, the Netherlands; Rowan Gallery, London, UK</li>
        <li>1969 Neue Nationalgalerie, Berlin, Germany</li>
        <li>1970 Musee d’Art Moderne de la Ville de Paris, France</li>
        <li>1976 Venice Biennale</li>
        <li>1989 Hayward Gallery, London, UK Retrospective: Museum of Modern Art, New York Retrospective: Museum Ludwig, Köln, Germany</li>
        <li>1991 Whitney Museum of American Art, New York</li>
        <li>1993 Kunsthalle Basel, Switzerland</li>
        <li>2001 Neue Nationalgalerie, Berlin, Germany</li>
        <li>2003 Museum of Modern Art, New York</li>
        <li>2004 Sprengel Museum, Hannover, Germany</li>
        <li>2006 Hauser &amp; Wirth, London, UK</li>
        <li>2007 Williams College Museum of Art, MA</li>
        <li>2008 Galerie Daniel Blau, München, Germany</li>
        <li>2009 Fine Art Museum of San Francisco; Gagosian Gallery, New York</li>
        <li>2011 National Gallery, Washington, DC; Villa Schöningen, Potsdam, Germany</li>
      </ul>
      <p class="wow fadeInLeft" data-wow-delay=".4s">In many ways, Andy Warhol refined and expanded the idea of what it means to be an artist. He frequently took on the position of a producer, rather than creator, not only as a painter with assistants doing much of the work to produce his paintings, but as a filmmaker and with his commercial enterprises as well. He liked to coin an idea and then oversee or delegate its execution. As he refined this element of his work, The Factory evolved from an atelier into an office. He became, and still is, the public face of a company and a brand, and the essence of Pop Art.</p>
      <p  class="wow fadeInRight" data-wow-delay=".4s"><img src="uploads/artists/Warhol/Warhol_selfPortrait1964.jpg" alt=" Picture of Andy Warhol" border="20"></p>
      <div class="boldcap wow fadeInRight" data-wow-delay=".4s">Self-Portrait, 1964</div>
      <p class="wow fadeInLeft" data-wow-delay=".4s">Still wondering about a painting in your family collection? <a href="https://www.artexpertswebsite.com/contact/contact1.php">Contact us</a>…it could be by Andy Warhol. If you think you may own a work by Andy Warhol, we can authenticate it. Please email Art Experts at <a href="mailto:info@artexpertswebsite.com">info@artexpertswebsite.com</a>.</p>
      
      
    </div>
    
    
    <?php include($_SERVER['DOCUMENT_ROOT']."/includes/right-sidebar.php");  ?>
    
    <!-- / main body -->

  </main>
</div>



<?php include($_SERVER['DOCUMENT_ROOT']."/includes/footer.php");  ?>



<?php include($_SERVER['DOCUMENT_ROOT']."/includes/copyright.php");  ?>


<a id="backtotop" href="#top"><i class="fa fa-chevron-up"></i></a>
<!-- JAVASCRIPTS -->
<script src="../layout/scripts/jquery.min.js"></script>
<script src="../layout/scripts/jquery.backtotop.js"></script>
<script src="../layout/scripts/jquery.mobilemenu.js"></script>
<script src="https://cdn.jsdelivr.net/npm/cookieconsent@3/build/cookieconsent.min.js" data-cfasync="false"></script>
<script>
window.cookieconsent.initialise({
  "palette": {
    "popup": {
      "background": "#474747"
    },
    "button": {
      "background": "#9d0552"
    }
  },
  "content": {
    "message": "This website uses cookies to improve your experience. We'll assume you're ok with this, but you can opt-out if you wish.",
    "dismiss": "Accept Cookies"
  }
});
</script>

</body>
</html>